/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.model.KryonId;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.VajramFacetDefinition;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputInjector
implements MainLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = InputInjector.class.getName();
    @NotOnlyInitialized
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider;

    public InputInjector(@UnderInitialization @UnknownKeyFor @NonNull VajramKryonGraph vajramKryonGraph, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.inputInjectionProvider = inputInjectionProvider;
    }

    public @UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        return inputsList -> {
            HashMap newInputsToOldInputs = new HashMap();
            ImmutableList inputValues = (ImmutableList)inputsList.stream().map(inputs -> {
                Inputs newInputs = this.injectFromSession(this.vajramKryonGraph.getVajramDefinition(VajramID.vajramID((String)Optional.ofNullable(originalLogicDefinition.kryonLogicId()).map(KryonLogicId::kryonId).map(KryonId::value).orElse(""))).orElse(null), (Inputs)inputs);
                newInputsToOldInputs.put(newInputs, inputs);
                return newInputs;
            }).collect(ImmutableList.toImmutableList());
            @Nullable ImmutableMap result = logicToDecorate.execute(inputValues);
            return (ImmutableMap)result.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> newInputsToOldInputs.getOrDefault(e.getKey(), (Inputs)e.getKey()), Map.Entry::getValue));
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return InputInjector.class.getName();
    }

    private @UnknownKeyFor @NonNull @Initialized Inputs injectFromSession(@Nullable @UnknownKeyFor @Initialized VajramDefinition vajramDefinition, @UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        HashMap newValues = new HashMap();
        ImmutableMap facetTags = vajramDefinition == null ? ImmutableMap.of() : vajramDefinition.getFacetTags();
        Optional.ofNullable(vajramDefinition).map(VajramDefinition::getVajram).map(Vajram::getInputDefinitions).ifPresent(facetDefinitions -> {
            for (VajramFacetDefinition inputDefinition : facetDefinitions) {
                String inputName = inputDefinition.name();
                if (!(inputDefinition instanceof Input)) continue;
                Input input = (Input)inputDefinition;
                if (input.sources().contains((Object)InputSource.CLIENT)) {
                    ValueOrError value = inputs.getInputValue(inputName);
                    if (!ValueOrError.empty().equals((Object)value)) continue;
                }
                if (!input.sources().contains((Object)InputSource.SESSION)) continue;
                ImmutableMap inputTags = (ImmutableMap)facetTags.getOrDefault((Object)inputName, (Object)ImmutableMap.of());
                ValueOrError<Object> value = this.getFromInjectionAdaptor(input.type(), Optional.ofNullable((Tag)inputTags.get(Named.class)).map(tag -> {
                    AnnotationTag anno;
                    Annotation patt5619$temp;
                    if (tag instanceof AnnotationTag && (patt5619$temp = (anno = (AnnotationTag)tag).annotation()) instanceof Named) {
                        Named named = (Named)patt5619$temp;
                        return named.value();
                    }
                    return null;
                }).orElse(null));
                newValues.put(inputName, value);
            }
        });
        if (!newValues.isEmpty()) {
            inputs.values().forEach(newValues::putIfAbsent);
            return new Inputs(newValues);
        }
        return inputs;
    }

    private @UnknownKeyFor @NonNull @Initialized ValueOrError<@UnknownKeyFor @NonNull @Initialized Object> getFromInjectionAdaptor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType, @Nullable @UnknownKeyFor @Initialized String injectionName) {
        Type type;
        if (this.inputInjectionProvider == null) {
            return ValueOrError.withError((Throwable)new Exception("Dependency injector is null, cannot resolve SESSION input"));
        }
        if (dataType == null) {
            return ValueOrError.withError((Throwable)new Exception("Data type not found"));
        }
        try {
            type = dataType.javaReflectType();
        }
        catch (ClassNotFoundException e) {
            return ValueOrError.withError((Throwable)e);
        }
        Object resolvedObject = null;
        if (injectionName != null) {
            resolvedObject = this.inputInjectionProvider.getInstance((Class)type, injectionName);
        }
        if (resolvedObject == null) {
            resolvedObject = this.inputInjectionProvider.getInstance((Class)type);
        }
        return ValueOrError.withValue(resolvedObject);
    }
}

