/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.testharness;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.AbstractKryonDecorator;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class VajramPrimer
extends AbstractKryonDecorator {
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Inputs, @UnknownKeyFor @NonNull @Initialized ValueOrError<@UnknownKeyFor @NonNull @Initialized Object>> executionStubs;
    private final @UnknownKeyFor @NonNull @Initialized VajramID decoratedVajramId;
    private final @UnknownKeyFor @NonNull @Initialized boolean failIfMockMissing;
    private @UnknownKeyFor @NonNull @Initialized VajramPrimer. @MonotonicNonNull @UnknownKeyFor @Initialized DecoratedKryon decoratedKryon;

    public <T> VajramPrimer(@UnknownKeyFor @NonNull @Initialized VajramID mockedVajramId, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramRequest<T>, @UnknownKeyFor @NonNull @Initialized ValueOrError<T>> stubs, @UnknownKeyFor @NonNull @Initialized boolean failIfMockMissing) {
        this.decoratedVajramId = mockedVajramId;
        this.failIfMockMissing = failIfMockMissing;
        LinkedHashMap mocks = new LinkedHashMap(stubs.size());
        stubs.forEach((req, resp) -> mocks.put(req.toInputValues(), resp));
        this.executionStubs = ImmutableMap.copyOf(mocks);
    }

    public @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> decorateKryon(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor) {
        if (this.decoratedKryon == null) {
            this.decoratedKryon = new DecoratedKryon(kryon, kryonExecutor);
        }
        return this.decoratedKryon;
    }

    private void flushDependencies(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor) {
        KryonDefinition kryonDefinition = kryon.getKryonDefinition();
        KryonId kryonId = kryonDefinition.kryonId();
        kryonDefinition.dependencyKryons().forEach((depName, depKryon) -> this.executeCommand((KryonCommand)new Flush(depKryon, forwardBatch.dependantChain().extend(kryonId, depName)), kryonExecutor));
    }

    private class DecoratedKryon
    implements Kryon<KryonCommand, KryonResponse> {
        private final @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon;
        private final @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor;

        private DecoratedKryon(@UnknownKeyFor @NonNull @Initialized Kryon<KryonCommand, KryonResponse> kryon, KryonExecutor kryonExecutor) {
            this.kryon = kryon;
            this.kryonExecutor = kryonExecutor;
        }

        public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
            this.validate(flushCommand.kryonId());
            this.kryon.executeCommand(flushCommand);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
            KryonId kryonId = kryonCommand.kryonId();
            this.validate(kryonId);
            if (kryonCommand instanceof ForwardGranule) {
                throw new UnsupportedOperationException("VajramPrimer does not support KryonExecStrategy GRANULAR. Please use BATCH instead");
            }
            if (kryonCommand instanceof Flush) {
                Flush flush = (Flush)kryonCommand;
                this.kryon.executeCommand(flush);
            } else if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                LinkedHashMap<RequestId, ValueOrError> finalResponses = new LinkedHashMap<RequestId, ValueOrError>();
                LinkedHashSet<RequestId> unmockedRequestIds = new LinkedHashSet<RequestId>();
                for (Map.Entry entry : forwardBatch.executableRequests().entrySet()) {
                    RequestId requestId = (RequestId)entry.getKey();
                    Inputs inputs = (Inputs)entry.getValue();
                    ValueOrError mockedResponse = (ValueOrError)VajramPrimer.this.executionStubs.get((Object)inputs);
                    if (mockedResponse == null) {
                        if (VajramPrimer.this.failIfMockMissing) {
                            throw new IllegalStateException("Could not find mocked response for inputs %s of kryon %s".formatted(inputs, kryonId));
                        }
                        unmockedRequestIds.add(requestId);
                        continue;
                    }
                    finalResponses.put(requestId, mockedResponse);
                }
                LinkedHashMap unmockedRequests = new LinkedHashMap(forwardBatch.executableRequests());
                unmockedRequests.keySet().retainAll(unmockedRequestIds);
                try {
                    if (!unmockedRequests.isEmpty()) {
                        CompletableFuture forwardedRequestsResult = this.kryon.executeCommand((KryonCommand)new ForwardBatch(forwardBatch.kryonId(), forwardBatch.inputNames(), ImmutableMap.copyOf(unmockedRequests), forwardBatch.dependantChain(), forwardBatch.skippedRequests()));
                        CompletionStage completionStage = forwardedRequestsResult.handle((kryonResponse, throwable) -> {
                            if (kryonResponse instanceof BatchResponse) {
                                BatchResponse batchResponse = (BatchResponse)kryonResponse;
                                finalResponses.putAll((Map<RequestId, ValueOrError>)batchResponse.responses());
                            } else {
                                ValueOrError error = throwable != null ? ValueOrError.withError((Throwable)throwable) : ValueOrError.withError((Throwable)((Object)new AssertionError((Object)"Unknown KryonResponse type of response %s from kryon %s".formatted(kryonResponse, kryonId))));
                                for (RequestId unmockedRequestId : unmockedRequestIds) {
                                    finalResponses.put(unmockedRequestId, error);
                                }
                            }
                            return new BatchResponse(ImmutableMap.copyOf((Map)finalResponses));
                        });
                        return completionStage;
                    }
                    CompletableFuture<BatchResponse> completableFuture = CompletableFuture.completedFuture(new BatchResponse(ImmutableMap.copyOf(finalResponses)));
                    return completableFuture;
                }
                finally {
                    VajramPrimer.this.flushDependencies(this.kryon, forwardBatch, this.kryonExecutor);
                }
            }
            return this.kryon.executeCommand(kryonCommand);
        }

        public @UnknownKeyFor @NonNull @Initialized KryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }

        private void validate(@UnknownKeyFor @NonNull @Initialized KryonId kryonId) {
            String vajramId = VajramPrimer.this.decoratedVajramId.vajramId();
            String kryondId = kryonId.value();
            if (!Objects.equals(kryondId, vajramId)) {
                throw new AssertionError((Object)"Vajram mocker for %s received command for %s".formatted(vajramId, kryondId));
            }
        }
    }
}

