/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecoratorCommand;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.FacetsConverter;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.flipkart.krystal.vajram.batching.UnBatchedFacets;
import com.flipkart.krystal.vajram.facets.FacetValuesAdaptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputBatchingDecorator<@UnknownKeyFor I extends @UnknownKeyFor @NonNull @Initialized FacetValuesAdaptor, @UnknownKeyFor C extends @UnknownKeyFor @NonNull @Initialized FacetValuesAdaptor>
implements OutputLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = InputBatchingDecorator.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized InputBatcher<I, C> inputBatcher;
    private final @UnknownKeyFor @NonNull @Initialized FacetsConverter<I, C> facetsConverter;
    private final @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized DependantChain> isApplicableToDependantChain;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Facets, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> futureCache = new HashMap<Facets, CompletableFuture<Object>>();
    private @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized DependantChain> activeDependantChains = ImmutableSet.of();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChains = new LinkedHashSet<DependantChain>();

    public InputBatchingDecorator(@UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized InputBatcher<I, C> inputBatcher, @UnknownKeyFor @NonNull @Initialized FacetsConverter<I, C> facetsConverter, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized DependantChain> isApplicableToDependantChain) {
        this.instanceId = instanceId;
        this.inputBatcher = inputBatcher;
        this.facetsConverter = facetsConverter;
        this.isApplicableToDependantChain = isApplicableToDependantChain;
    }

    public @UnknownKeyFor @NonNull @Initialized OutputLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized OutputLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        this.inputBatcher.onBatching(requests -> requests.forEach(request -> this.batchFacetsList(logicToDecorate, (BatchedFacets<I, C>)request)));
        return facetsList -> {
            List<UnBatchedFacets> requests = facetsList.stream().map(facets -> new UnBatchedFacets(this.facetsConverter.getBatched(facets), this.facetsConverter.getCommon(facets))).toList();
            List batchedFacetsList = requests.stream().map(unbatchedInput -> this.inputBatcher.add((Object)unbatchedInput.batchedInputs(), (Object)unbatchedInput.commonFacets())).flatMap(Collection::stream).toList();
            requests.forEach(request -> this.futureCache.computeIfAbsent(request.toFacetValues(), e -> new CompletableFuture()));
            for (BatchedFacets batchedFacets : batchedFacetsList) {
                this.batchFacetsList(logicToDecorate, batchedFacets);
            }
            return (ImmutableMap)requests.stream().map(UnBatchedFacets::toFacetValues).collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Optional.ofNullable(this.futureCache.get(key)).orElseThrow(() -> new AssertionError((Object)"Future cache has been primed with values. This should never happen"))));
        };
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized LogicDecoratorCommand logicDecoratorCommand) {
        if (logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            LinkedHashSet<DependantChain> allActiveDepChains = new LinkedHashSet<DependantChain>((Collection<DependantChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependantChain.negate());
            this.activeDependantChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.flushedDependantChains.add(flushCommand.dependantsChain());
            if (this.flushedDependantChains.containsAll((Collection<?>)this.activeDependantChains)) {
                this.inputBatcher.batch();
                this.flushedDependantChains.clear();
            }
        }
    }

    private void batchFacetsList(@UnknownKeyFor @NonNull @Initialized OutputLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized BatchedFacets<I, C> batchedFacets) {
        ImmutableList requests = (ImmutableList)batchedFacets.batch().stream().map(each -> new UnBatchedFacets(each, (FacetValuesAdaptor)batchedFacets.commonFacets())).collect(ImmutableList.toImmutableList());
        logicToDecorate.execute((ImmutableList)requests.stream().map(UnBatchedFacets::toFacetValues).collect(ImmutableList.toImmutableList())).forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent((Facets)inputs, request -> new CompletableFuture())));
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.inputBatcher.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_batching.%s.", this.instanceId), configProvider));
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.instanceId;
    }
}

