/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.testharness;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.krystex.caching.RequestLevelCache;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class VajramTestHarness {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramRequest<@UnknownKeyFor @NonNull @Initialized Object>, @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object>>> vajramIdMockData;
    private final @UnknownKeyFor @NonNull @Initialized KrystexVajramExecutorConfig kryonExecutorConfigBuilder;
    private final @UnknownKeyFor @NonNull @Initialized RequestLevelCache requestLevelCache;

    @Inject
    public VajramTestHarness(@UnknownKeyFor @NonNull @Initialized KrystexVajramExecutorConfig kryonExecutorBuilder, @UnknownKeyFor @NonNull @Initialized RequestLevelCache requestLevelCache) {
        this.kryonExecutorConfigBuilder = kryonExecutorBuilder;
        this.requestLevelCache = requestLevelCache;
        this.vajramIdMockData = new HashMap<String, Map<VajramRequest<Object>, Errable<Object>>>();
    }

    public static @UnknownKeyFor @NonNull @Initialized VajramTestHarness prepareForTest(@UnknownKeyFor @NonNull @Initialized KrystexVajramExecutorConfig kryonExecutorBuilder, @UnknownKeyFor @NonNull @Initialized RequestLevelCache requestLevelCache) {
        return new VajramTestHarness(kryonExecutorBuilder, requestLevelCache);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized VajramTestHarness withMock(@UnknownKeyFor @NonNull @Initialized VajramRequest<T> request, @UnknownKeyFor @NonNull @Initialized Errable<T> response) {
        int index;
        String requestName = request.getClass().getSimpleName();
        String vajramId = requestName.substring(0, index = requestName.lastIndexOf(82));
        Map<VajramRequest<Object>, Errable<Object>> mockDataMap = this.vajramIdMockData.get(vajramId);
        if (Objects.isNull(mockDataMap)) {
            this.vajramIdMockData.put(vajramId, Map.of(request, response));
        } else {
            Errable<Object> errable = mockDataMap.get(request);
            if (Objects.isNull(errable)) {
                mockDataMap.put(request, response);
                this.vajramIdMockData.put(vajramId, mockDataMap);
            }
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized KrystexVajramExecutorConfig buildConfig() {
        this.vajramIdMockData.forEach((s, vajramRequestErrableMap) -> vajramRequestErrableMap.forEach((objectVajramRequest, objectErrable) -> this.requestLevelCache.primeCache(s, objectVajramRequest.toFacetValues(), objectErrable.toFuture())));
        KryonDecoratorConfig kryonDecoratorConfig = (KryonDecoratorConfig)this.kryonExecutorConfigBuilder.kryonExecutorConfigBuilder().build().requestScopedKryonDecoratorConfigs().get(RequestLevelCache.DECORATOR_TYPE);
        if (kryonDecoratorConfig == null) {
            this.kryonExecutorConfigBuilder.kryonExecutorConfigBuilder().requestScopedKryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, new KryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, executionContext -> this.vajramIdMockData.containsKey(executionContext.kryonId().value()), executionContext -> RequestLevelCache.DECORATOR_TYPE, kryonExecutionContext -> this.requestLevelCache));
        }
        return this.kryonExecutorConfigBuilder;
    }
}

