/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InjectingDecoratedKryon
implements Kryon<KryonCommand, KryonResponse> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(InjectingDecoratedKryon.class);
    private final @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon;
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider;

    InjectingDecoratedKryon(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider) {
        this.kryon = kryon;
        this.vajramKryonGraph = vajramKryonGraph;
        this.inputInjectionProvider = inputInjectionProvider;
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
        this.kryon.executeCommand(flushCommand);
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinition getKryonDefinition() {
        return this.kryon.getKryonDefinition();
    }

    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
        if (kryonCommand instanceof ForwardBatch) {
            ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
            return this.injectFacets(this.kryon, forwardBatch);
        }
        if (kryonCommand instanceof ForwardGranule) {
            UnsupportedOperationException e = new UnsupportedOperationException("KryonInputInjector does not support KryonExecStrategy GRANULAR. Please use BATCH instead");
            log.error("", (Throwable)e);
            throw e;
        }
        return this.kryon.executeCommand(kryonCommand);
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> injectFacets(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch) {
        ImmutableMap requestIdToFacets = forwardBatch.executableRequests();
        LinkedHashSet<String> newInputsNames = new LinkedHashSet<String>((Collection<String>)forwardBatch.inputNames());
        ImmutableMap.Builder newRequests = ImmutableMap.builder();
        for (Map.Entry entry : requestIdToFacets.entrySet()) {
            RequestId requestId = (RequestId)entry.getKey();
            Facets facets = (Facets)entry.getValue();
            Facets newFacets = this.injectFacetsOfVajram(this.vajramKryonGraph.getVajramDefinition(VajramID.vajramID((String)forwardBatch.kryonId().value())).orElse(null), facets, this.inputInjectionProvider, newInputsNames);
            newRequests.put((Object)requestId, (Object)newFacets);
        }
        return kryon.executeCommand((KryonCommand)new ForwardBatch(forwardBatch.kryonId(), ImmutableSet.copyOf(newInputsNames), newRequests.build(), forwardBatch.dependantChain(), forwardBatch.skippedRequests()));
    }

    private @UnknownKeyFor @NonNull @Initialized Facets injectFacetsOfVajram(@Nullable @UnknownKeyFor @Initialized VajramDefinition vajramDefinition, @UnknownKeyFor @NonNull @Initialized Facets facets, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> newInputNames) {
        HashMap newValues = new HashMap();
        ImmutableMap facetTags = vajramDefinition == null ? ImmutableMap.of() : vajramDefinition.getFacetTags();
        Optional.ofNullable(vajramDefinition).map(VajramDefinition::getVajram).map(Vajram::getFacetDefinitions).ifPresent(facetDefinitions -> {
            for (VajramFacetDefinition facetDefinition : facetDefinitions) {
                String inputName = facetDefinition.name();
                if (!(facetDefinition instanceof InputDef)) continue;
                InputDef inputDef = (InputDef)facetDefinition;
                if (inputDef.sources().contains((Object)InputSource.CLIENT)) {
                    Errable value = facets.getInputValue(inputName);
                    if (!Errable.empty().equals((Object)value)) continue;
                }
                if (!inputDef.sources().contains((Object)InputSource.SESSION)) continue;
                ImmutableMap inputTags = (ImmutableMap)facetTags.getOrDefault((Object)inputName, (Object)ImmutableMap.of());
                Errable<Object> value = this.getFromInjectionAdaptor(inputDef, Optional.ofNullable((Tag)inputTags.get(Named.class)).map(tag -> {
                    AnnotationTag annoTag;
                    Annotation patt6002$temp;
                    if (tag instanceof AnnotationTag && (patt6002$temp = (annoTag = (AnnotationTag)tag).tagValue()) instanceof Named) {
                        Named named = (Named)patt6002$temp;
                        return named.value();
                    }
                    return null;
                }).orElse(null), inputInjectionProvider);
                newValues.put(inputName, value);
                newInputNames.add(inputName);
            }
        });
        if (!newValues.isEmpty()) {
            facets.values().forEach(newValues::putIfAbsent);
            return new Facets(newValues);
        }
        return facets;
    }

    private @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object> getFromInjectionAdaptor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InputDef<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputDef, @Nullable @UnknownKeyFor @Initialized String injectionName, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider) {
        if (inputInjectionProvider == null) {
            RuntimeException exception = new RuntimeException("Dependency injector is null, cannot resolve SESSION input");
            log.error("", (Throwable)exception);
            return Errable.withError((Throwable)exception);
        }
        if (inputDef == null) {
            RuntimeException exception = new RuntimeException("Data type not found");
            log.error("", (Throwable)exception);
            return Errable.withError((Throwable)exception);
        }
        return Errable.errableFrom(() -> {
            try {
                Type type = inputDef.type().javaReflectType();
                return injectionName != null ? inputInjectionProvider.getInstance((Class)type, injectionName) : inputInjectionProvider.getInstance((Class)type);
            }
            catch (Exception e) {
                log.error("Could not inject input {} of vajram {}", new Object[]{inputDef, this.kryon.getKryonDefinition().kryonId().value(), e});
                throw e;
            }
        });
    }
}

