/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.testharness;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorationInput;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecorator;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.vajram.VajramRequest;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VajramPrimer
implements KryonDecorator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramPrimer.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Facets, @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object>>> responsesByFacets;
    private final @UnknownKeyFor @NonNull @Initialized boolean failIfNotPrimed;

    public <T> VajramPrimer(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramRequest<T>, @UnknownKeyFor @NonNull @Initialized Errable<T>>> primedResponses, @UnknownKeyFor @NonNull @Initialized boolean failIfNotPrimed) {
        this.failIfNotPrimed = failIfNotPrimed;
        this.responsesByFacets = new LinkedHashMap<String, Map<Facets, Errable<Object>>>();
        primedResponses.forEach((s, vajramRequestErrableMap) -> vajramRequestErrableMap.forEach((tVajramRequest, tErrable) -> this.responsesByFacets.computeIfAbsent((String)s, _s -> new LinkedHashMap()).computeIfAbsent(tVajramRequest.toFacetValues(), _f -> tErrable)));
    }

    public @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> decorateKryon(@UnknownKeyFor @NonNull @Initialized KryonDecorationInput decorationInput) {
        return new PrimingDecoratedKryon((Kryon<KryonCommand, KryonResponse>)decorationInput.kryon(), decorationInput.kryonExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> getPrimedResponse(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch, @UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor) {
        LinkedHashMap<RequestId, Errable> finalResponses = new LinkedHashMap<RequestId, Errable>();
        LinkedHashSet<RequestId> nonPrimedRequestIds = new LinkedHashSet<RequestId>();
        for (Map.Entry entry : forwardBatch.executableRequests().entrySet()) {
            RequestId requestId = (RequestId)entry.getKey();
            Facets facets = (Facets)entry.getValue();
            Errable primedResponse = (Errable)this.responsesByFacets.getOrDefault(kryonId.value(), Map.of()).get(facets);
            if (primedResponse == null) {
                if (this.failIfNotPrimed) {
                    throw new IllegalStateException("Could not find primed response for inputs %s of kryon %s".formatted(facets, kryonId));
                }
                nonPrimedRequestIds.add(requestId);
                continue;
            }
            finalResponses.put(requestId, primedResponse);
        }
        LinkedHashMap unprimedRequests = new LinkedHashMap(forwardBatch.executableRequests());
        unprimedRequests.keySet().retainAll(nonPrimedRequestIds);
        try {
            if (!unprimedRequests.isEmpty()) {
                CompletableFuture forwardedRequestsResult = kryon.executeCommand((KryonCommand)new ForwardBatch(forwardBatch.kryonId(), forwardBatch.inputNames(), ImmutableMap.copyOf(unprimedRequests), forwardBatch.dependantChain(), forwardBatch.skippedRequests()));
                CompletionStage completionStage = forwardedRequestsResult.handle((kryonResponse, throwable) -> {
                    if (kryonResponse instanceof BatchResponse) {
                        BatchResponse batchResponse = (BatchResponse)kryonResponse;
                        finalResponses.putAll((Map<RequestId, Errable>)batchResponse.responses());
                    } else {
                        Errable error = throwable != null ? Errable.withError((Throwable)throwable) : Errable.withError((Throwable)((Object)new AssertionError((Object)"Unknown KryonResponse type of response %s from kryon %s".formatted(kryonResponse, kryonId))));
                        for (RequestId unprimedRequestId : nonPrimedRequestIds) {
                            finalResponses.put(unprimedRequestId, error);
                        }
                    }
                    return new BatchResponse(ImmutableMap.copyOf((Map)finalResponses));
                });
                return completionStage;
            }
            CompletableFuture<BatchResponse> completableFuture = CompletableFuture.completedFuture(new BatchResponse(ImmutableMap.copyOf(finalResponses)));
            return completableFuture;
        }
        finally {
            this.flushDependencies(kryon, forwardBatch, kryonExecutor);
        }
    }

    private void flushDependencies(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch, @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor) {
        KryonDefinition kryonDefinition = kryon.getKryonDefinition();
        KryonId kryonId = kryonDefinition.kryonId();
        kryonDefinition.dependencyKryons().forEach((depName, depKryon) -> {
            Flush kryonCommand = new Flush(depKryon, forwardBatch.dependantChain().extend(kryonId, depName));
            kryonExecutor.executeCommand((KryonCommand)kryonCommand);
        });
    }

    private class PrimingDecoratedKryon
    implements Kryon<KryonCommand, KryonResponse> {
        private final @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon;
        private final @UnknownKeyFor @NonNull @Initialized KryonExecutor kryonExecutor;

        private PrimingDecoratedKryon(@UnknownKeyFor @NonNull @Initialized Kryon<KryonCommand, KryonResponse> kryon, KryonExecutor kryonExecutor) {
            this.kryon = kryon;
            this.kryonExecutor = kryonExecutor;
        }

        public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
            this.kryon.executeCommand(flushCommand);
        }

        public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
            KryonId kryonId = kryonCommand.kryonId();
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                return VajramPrimer.this.getPrimedResponse(this.kryon, forwardBatch, kryonId, this.kryonExecutor);
            }
            if (kryonCommand instanceof ForwardGranule) {
                throw new UnsupportedOperationException("VajramPrimer does not support KryonExecStrategy GRANULAR. Please use BATCH instead");
            }
            return this.kryon.executeCommand(kryonCommand);
        }

        public @UnknownKeyFor @NonNull @Initialized KryonDefinition getKryonDefinition() {
            return this.kryon.getKryonDefinition();
        }
    }
}

