/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.testharness;

import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.krystex.caching.RequestLevelCache;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class VajramTestHarness {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramRequest<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object>, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Errable<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Object>>> vajramIdMockData;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KrystexVajramExecutorConfig kryonExecutorConfigBuilder;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) RequestLevelCache requestLevelCache;

    @Inject
    public VajramTestHarness(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KrystexVajramExecutorConfig krystexVajramExecutorConfig, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) RequestLevelCache requestLevelCache) {
        this.kryonExecutorConfigBuilder = krystexVajramExecutorConfig;
        this.requestLevelCache = requestLevelCache;
        this.vajramIdMockData = new HashMap<String, Map<VajramRequest<Object>, Errable<Object>>>();
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramTestHarness prepareForTest(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KrystexVajramExecutorConfig executorConfig, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) RequestLevelCache requestLevelCache) {
        return new VajramTestHarness(executorConfig, requestLevelCache);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramTestHarness withMock(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) VajramRequest<T> request, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Errable<T> response) {
        int index;
        String requestName = request.getClass().getSimpleName();
        String vajramId = requestName.substring(0, index = requestName.lastIndexOf(82));
        Map<VajramRequest<Object>, Errable<Object>> mockDataMap = this.vajramIdMockData.get(vajramId);
        if (Objects.isNull(mockDataMap)) {
            this.vajramIdMockData.put(vajramId, Map.of(request, response));
        } else {
            Errable<Object> errable = mockDataMap.get(request);
            if (Objects.isNull(errable)) {
                mockDataMap.put(request, response);
                this.vajramIdMockData.put(vajramId, mockDataMap);
            }
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) KrystexVajramExecutorConfig buildConfig() {
        this.vajramIdMockData.forEach((s, vajramRequestErrableMap) -> vajramRequestErrableMap.forEach((objectVajramRequest, objectErrable) -> this.requestLevelCache.primeCache(s, objectVajramRequest.toFacetValues(), objectErrable.toFuture())));
        KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder = this.kryonExecutorConfigBuilder.kryonExecutorConfigBuilder().singleThreadExecutor(new SingleThreadExecutor("VajramTestHarness"));
        KryonDecoratorConfig kryonDecoratorConfig = (KryonDecoratorConfig)configBuilder.build().requestScopedKryonDecoratorConfigs().get(RequestLevelCache.DECORATOR_TYPE);
        if (kryonDecoratorConfig == null) {
            this.kryonExecutorConfigBuilder.kryonExecutorConfigBuilder().requestScopedKryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, new KryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, executionContext -> this.vajramIdMockData.containsKey(executionContext.kryonId().value()), executionContext -> RequestLevelCache.DECORATOR_TYPE, kryonExecutionContext -> this.requestLevelCache));
        }
        return this.kryonExecutorConfigBuilder;
    }
}

