/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecoratorCommand;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class InputBatchingDecorator
implements OutputLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = InputBatchingDecorator.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputBatcher inputBatcher;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Predicate<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain> isApplicableToDependantChain;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValues, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>> futureCache = new LinkedHashMap<ImmutableFacetValues, CompletableFuture<Object>>();
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain> activeDependantChains = ImmutableSet.of();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Set<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain> flushedDependantChains = new LinkedHashSet<DependantChain>();

    public InputBatchingDecorator(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String instanceId, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputBatcher inputBatcher, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Predicate<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DependantChain> isApplicableToDependantChain) {
        this.instanceId = instanceId;
        this.inputBatcher = inputBatcher;
        this.isApplicableToDependantChain = isApplicableToDependantChain;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> originalLogicDefinition) {
        this.inputBatcher.onBatching(requests -> requests.forEach(request -> this.batchFacetsList(logicToDecorate, (BatchedFacets)request)));
        return facetsList -> {
            ImmutableList immutableFacetsList = (ImmutableList)facetsList.stream().map(f -> {
                if (f instanceof BatchEnabledFacetValues) {
                    return (BatchEnabledFacetValues)f;
                }
                throw new IllegalStateException("Expected to recieve instance of BatchableFacets in batcher %s but received %s".formatted(this.instanceId, Optional.ofNullable(f).map(Object::getClass).orElse(Void.class)));
            }).map(BatchEnabledFacetValues::_build).collect(ImmutableList.toImmutableList());
            List batchedFacetsList = immutableFacetsList.stream().map(f -> f).map(arg_0 -> ((InputBatcher)this.inputBatcher).add(arg_0)).flatMap(Collection::stream).toList();
            facetsList.forEach(facets -> this.futureCache.computeIfAbsent(facets._build(), e -> new CompletableFuture()));
            for (BatchedFacets batchedFacets : batchedFacetsList) {
                this.batchFacetsList(logicToDecorate, batchedFacets);
            }
            return (ImmutableMap)facetsList.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Optional.ofNullable(this.futureCache.get(key._build())).orElseThrow(() -> new AssertionError((Object)"Future cache has been primed with values. This should never happen"))));
        };
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent LogicDecoratorCommand logicDecoratorCommand) {
        if (logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            LinkedHashSet<DependantChain> allActiveDepChains = new LinkedHashSet<DependantChain>((Collection<DependantChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependantChain.negate());
            this.activeDependantChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.flushedDependantChains.add(flushCommand.dependantsChain());
            if (this.flushedDependantChains.containsAll((Collection<?>)this.activeDependantChains)) {
                this.inputBatcher.batch();
                this.flushedDependantChains.clear();
            }
        }
    }

    private void batchFacetsList(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent OutputLogic<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BatchedFacets batchedFacets) {
        ImmutableMap result;
        ImmutableList facetsList = batchedFacets.batchItems();
        try {
            result = logicToDecorate.execute(facetsList);
        }
        catch (Throwable e) {
            result = (ImmutableMap)facetsList.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), i -> CompletableFuture.failedFuture(e)));
        }
        result.forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent(inputs._build(), request -> new CompletableFuture())));
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ConfigProvider configProvider) {
        this.inputBatcher.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_batching.%s.", this.instanceId), configProvider));
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getId() {
        return this.instanceId;
    }
}

