/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.commands.ClientSideCommand;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardSend;
import com.flipkart.krystal.krystex.dependencydecoration.VajramInvocation;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.FlushResponse;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.traits.PredicateDynamicDispatchPolicy;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.flipkart.krystal.traits.matchers.InputValueMatcher;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class TraitDispatchDecoratorImpl
implements TraitDispatchDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String DECORATOR_TYPE = StaticDispatchPolicy.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph vajramKryonGraph;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TraitDispatchPolicy> traitDispatchPolicies;

    public TraitDispatchDecoratorImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph vajramKryonGraph, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TraitDispatchPolicy> traitDispatchPolicies) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.traitDispatchPolicies = traitDispatchPolicies;
    }

    public <R extends KryonResponse> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInvocation<R> decorateDependency(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInvocation<R> invocationToDecorate) {
        return kryonCommand -> {
            VajramID traitId = kryonCommand.vajramID();
            VajramDefinition vajramDefinition = this.vajramKryonGraph.getVajramDefinition(traitId);
            if (!vajramDefinition.isTrait()) {
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            TraitDispatchPolicy traitDispatchPolicy = (TraitDispatchPolicy)this.traitDispatchPolicies.get((Object)traitId);
            if (traitDispatchPolicy instanceof StaticDispatchPolicy) {
                StaticDispatchPolicy staticDispatchDefinition = (StaticDispatchPolicy)traitDispatchPolicy;
                Dependency dependency = kryonCommand.dependantChain().latestDependency();
                if (dependency == null) {
                    throw new AssertionError((Object)"This is not possible. A dependency decorator can only be invoked when there is a depednency present.");
                }
                VajramID boundVajram = staticDispatchDefinition.get(dependency);
                ClientSideCommand commandToDispatch = TraitDispatchDecoratorImpl.transformCommandForDispatch(kryonCommand, boundVajram);
                if (commandToDispatch == null) {
                    commandToDispatch = kryonCommand;
                }
                return invocationToDecorate.invokeDependency(commandToDispatch);
            }
            if (traitDispatchPolicy instanceof PredicateDynamicDispatchPolicy) {
                PredicateDynamicDispatchPolicy dynamicPolicy = (PredicateDynamicDispatchPolicy)traitDispatchPolicy;
                Set dispatchEnabledFacets = dynamicPolicy.facets().stream().filter(facet -> facet instanceof InputMirrorSpec).map(facet -> (InputMirrorSpec)facet).collect(Collectors.toSet());
                ImmutableList dispatchCases = dynamicPolicy.dispatchCases();
                if (kryonCommand instanceof ForwardSend) {
                    ForwardSend forwardSend = (ForwardSend)kryonCommand;
                    ImmutableMap executabledRequests = forwardSend.executableRequests();
                    LinkedHashMap dispatchRequests = new LinkedHashMap();
                    LinkedHashMap<VajramID, CompletableFuture> dispatchResponses = new LinkedHashMap<VajramID, CompletableFuture>();
                    LinkedHashSet<RequestId> orphanedRequests = new LinkedHashSet<RequestId>();
                    for (Map.Entry requestEntry : executabledRequests.entrySet()) {
                        RequestId requestId = (RequestId)requestEntry.getKey();
                        Request originalRequest = (Request)requestEntry.getValue();
                        boolean dispatchTargetNotFound = true;
                        for (PredicateDynamicDispatchPolicy.DispatchCase dispatchCase : dispatchCases) {
                            boolean caseMatches = true;
                            for (InputMirrorSpec dispatchEnabledFacet : dispatchEnabledFacets) {
                                Object inputValue = dispatchEnabledFacet.getFromRequest(originalRequest);
                                if (((InputValueMatcher)dispatchCase.inputPredicates().getOrDefault((Object)dispatchEnabledFacet, (Object)InputValueMatcher.isAnyValue())).matches(inputValue)) continue;
                                caseMatches = false;
                                break;
                            }
                            if (!caseMatches) continue;
                            dispatchRequests.computeIfAbsent(dispatchCase.dispatchTarget(), k -> new LinkedHashMap()).put(requestId, originalRequest);
                            dispatchTargetNotFound = false;
                            break;
                        }
                        if (!dispatchTargetNotFound) continue;
                        orphanedRequests.add(requestId);
                    }
                    ImmutableList dispatchTargets = dynamicPolicy.dispatchTargets();
                    for (VajramID dispatchTarget : dispatchTargets) {
                        Map requestsForTarget = dispatchRequests.getOrDefault(dispatchTarget, Map.of());
                        ForwardSend commandToDispatch = requestsForTarget.isEmpty() ? new ForwardSend(dispatchTarget, ImmutableMap.of(), forwardSend.dependantChain(), (ImmutableMap)executabledRequests.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), _r -> "None of the requests to trait " + traitId + " matched " + dispatchTarget + " via dynamic predicate dispatch"))) : new ForwardSend(dispatchTarget, ImmutableMap.copyOf(requestsForTarget), forwardSend.dependantChain(), ImmutableMap.of());
                        dispatchResponses.put(dispatchTarget, invocationToDecorate.invokeDependency((ClientSideCommand)commandToDispatch));
                    }
                    CompletableFuture mergedResponse = new CompletableFuture();
                    CompletableFuture.allOf((CompletableFuture[])dispatchResponses.values().stream().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
                        LinkedHashMap<RequestId, Errable> mergedResults = new LinkedHashMap<RequestId, Errable>();
                        for (Map.Entry dispatchResponseEntry : dispatchResponses.entrySet()) {
                            VajramID dispatchTarget = (VajramID)dispatchResponseEntry.getKey();
                            CompletableFuture dispatchResponse = (CompletableFuture)dispatchResponseEntry.getValue();
                            if (dispatchResponse.isCompletedExceptionally()) {
                                try {
                                    dispatchResponse.join();
                                    continue;
                                }
                                catch (Throwable e) {
                                    Set requestIds = dispatchRequests.getOrDefault(dispatchTarget, Map.of()).keySet();
                                    for (RequestId id : requestIds) {
                                        mergedResults.put(id, Errable.withError((Throwable)e));
                                    }
                                    continue;
                                }
                            }
                            BatchResponse resultValue = dispatchResponse.getNow(BatchResponse.empty());
                            mergedResults.putAll((Map<RequestId, Errable>)resultValue.responses());
                        }
                        mergedResponse.complete(new BatchResponse(ImmutableMap.copyOf(mergedResults)));
                    });
                    return mergedResponse;
                }
                if (kryonCommand instanceof Flush) {
                    Flush flush = (Flush)kryonCommand;
                    ArrayList<CompletableFuture> flushResponses = new ArrayList<CompletableFuture>();
                    for (VajramID dispatchTarget : dynamicPolicy.dispatchTargets()) {
                        CompletableFuture flushResponse = invocationToDecorate.invokeDependency((ClientSideCommand)new Flush(dispatchTarget, flush.dependantChain()));
                        flushResponses.add(flushResponse);
                    }
                    return CompletableFuture.allOf((CompletableFuture[])flushResponses.toArray(CompletableFuture[]::new)).handle((unused, throwable) -> FlushResponse.getInstance());
                }
                throw new IllegalStateException("Unknown command type: " + kryonCommand);
            }
            throw new IllegalStateException("Unknown dispatch policy: " + traitDispatchPolicy);
        };
    }

    private static <R extends KryonResponse> @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClientSideCommand<R> transformCommandForDispatch(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClientSideCommand<R> kryonCommand, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID boundVajram) {
        Flush commandToDispatch = null;
        if (kryonCommand instanceof ForwardSend) {
            ForwardSend forwardSend = (ForwardSend)kryonCommand;
            commandToDispatch = new ForwardSend(boundVajram, forwardSend.executableRequests(), forwardSend.dependantChain(), forwardSend.skippedRequests());
        } else if (kryonCommand instanceof Flush) {
            commandToDispatch = new Flush(boundVajram, kryonCommand.dependantChain());
        }
        return commandToDispatch;
    }

    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramID, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TraitDispatchPolicy> traitDispatchPolicies() {
        return this.traitDispatchPolicies;
    }
}

