/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecoratorCommand;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InputBatchingDecorator
implements OutputLogicDecorator {
    public static final String DECORATOR_TYPE = InputBatchingDecorator.class.getName();
    private final String instanceId;
    private final InputBatcher inputBatcher;
    private final Predicate<DependentChain> isApplicableToDependantChain;
    private final Map<ImmutableFacetValues, CompletableFuture<@Nullable Object>> futureCache = new LinkedHashMap<ImmutableFacetValues, CompletableFuture<Object>>();
    private ImmutableSet<DependentChain> activeDependentChains = ImmutableSet.of();
    private final Set<DependentChain> flushedDependentChains = new LinkedHashSet<DependentChain>();

    public InputBatchingDecorator(String instanceId, InputBatcher inputBatcher, Predicate<DependentChain> isApplicableToDependantChain) {
        this.instanceId = instanceId;
        this.inputBatcher = inputBatcher;
        this.isApplicableToDependantChain = isApplicableToDependantChain;
    }

    public OutputLogic<Object> decorateLogic(OutputLogic<Object> logicToDecorate, OutputLogicDefinition<Object> originalLogicDefinition) {
        this.inputBatcher.onBatching(requests -> requests.forEach(request -> this.batchFacetsList(logicToDecorate, (BatchedFacets)request)));
        return facetsList -> {
            ImmutableList immutableFacetsList = (ImmutableList)facetsList.stream().map(f -> {
                if (f instanceof BatchEnabledFacetValues) {
                    return (BatchEnabledFacetValues)f;
                }
                throw new IllegalStateException("Expected to recieve instance of BatchEnabledFacetValues in batcher %s but received %s".formatted(this.instanceId, f));
            }).map(BatchEnabledFacetValues::_build).collect(ImmutableList.toImmutableList());
            List batchedFacetsList = immutableFacetsList.stream().map(f -> f).map(arg_0 -> ((InputBatcher)this.inputBatcher).add(arg_0)).flatMap(Collection::stream).toList();
            facetsList.forEach(facets -> this.futureCache.computeIfAbsent(facets._build(), e -> new CompletableFuture()));
            for (BatchedFacets batchedFacets : batchedFacetsList) {
                this.batchFacetsList(logicToDecorate, batchedFacets);
            }
            return (ImmutableMap)facetsList.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Objects.requireNonNullElseGet(this.futureCache.get(key._build()), CompletableFuture::new)));
        };
    }

    public void executeCommand(LogicDecoratorCommand logicDecoratorCommand) {
        if (logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            LinkedHashSet<DependentChain> allActiveDepChains = new LinkedHashSet<DependentChain>((Collection<DependentChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependantChain.negate());
            this.activeDependentChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.flushedDependentChains.add(flushCommand.dependantsChain());
            if (this.flushedDependentChains.containsAll((Collection<?>)this.activeDependentChains)) {
                this.inputBatcher.batch();
                this.flushedDependentChains.clear();
            }
        }
    }

    private void batchFacetsList(OutputLogic<Object> logicToDecorate, BatchedFacets batchedFacets) {
        ImmutableMap result;
        ImmutableList facetsList = batchedFacets.batchItems();
        try {
            result = logicToDecorate.execute(facetsList);
        }
        catch (Throwable e) {
            result = (ImmutableMap)facetsList.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), i -> CompletableFuture.failedFuture(e)));
        }
        result.forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent(inputs._build(), request -> new CompletableFuture())));
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.inputBatcher.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_batching.%s.", this.instanceId), configProvider));
    }

    public String getId() {
        return this.instanceId;
    }
}

