/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.FacetValuesBuilder;
import com.flipkart.krystal.data.FacetValuesContainer;
import com.flipkart.krystal.data.Failure;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.data.Success;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardReceive;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.kryon.VajramKryonDefinition;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.specs.DefaultFacetSpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InjectingDecoratedKryon
implements Kryon<KryonCommand, KryonCommandResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InjectingDecoratedKryon.class);
    private final Kryon<KryonCommand, KryonCommandResponse> kryon;
    private final VajramKryonGraph vajramKryonGraph;
    private final @Nullable VajramInjectionProvider injectionProvider;

    InjectingDecoratedKryon(Kryon<KryonCommand, KryonCommandResponse> kryon, VajramKryonGraph vajramKryonGraph, @Nullable VajramInjectionProvider injectionProvider) {
        this.kryon = kryon;
        this.vajramKryonGraph = vajramKryonGraph;
        this.injectionProvider = injectionProvider;
    }

    public void executeCommand(Flush flushCommand) {
        this.kryon.executeCommand(flushCommand);
    }

    public VajramKryonDefinition getKryonDefinition() {
        return this.kryon.getKryonDefinition();
    }

    public CompletableFuture<KryonCommandResponse> executeCommand(KryonCommand kryonCommand) {
        VajramDefRoot vajramDefRoot;
        VajramDefinition vajramDefinition = this.vajramKryonGraph.getVajramDefinition(VajramID.vajramID((String)kryonCommand.vajramID().id()));
        if (vajramDefinition.metadata().isInputInjectionNeeded() && (vajramDefRoot = vajramDefinition.def()) instanceof VajramDef) {
            VajramDef vajramDef = (VajramDef)vajramDefRoot;
            if (kryonCommand instanceof ForwardReceive) {
                ForwardReceive forwardBatch = (ForwardReceive)kryonCommand;
                return this.injectFacets(forwardBatch, vajramDefinition, vajramDef);
            }
        }
        return this.kryon.executeCommand(kryonCommand);
    }

    private CompletableFuture<KryonCommandResponse> injectFacets(ForwardReceive forwardBatch, VajramDefinition vajramDefinition, VajramDef<?> vajramDef) {
        ImmutableMap requestIdToFacets = forwardBatch.executableInvocations();
        ImmutableMap.Builder newRequests = ImmutableMap.builder();
        LinkedHashSet injectableFacets = new LinkedHashSet();
        vajramDefinition.facetSpecs().forEach(facetSpec -> {
            if (facetSpec.facetTypes().contains((Object)FacetType.INJECTION)) {
                injectableFacets.add((FacetSpec<?, ?>)facetSpec);
            }
        });
        for (Map.Entry entry : requestIdToFacets.entrySet()) {
            FacetValuesBuilder facetsBuilder;
            InvocationId invocationId = (InvocationId)entry.getKey();
            FacetValuesContainer container = (FacetValuesContainer)entry.getValue();
            if (container instanceof Request) {
                Request request = (Request)container;
                facetsBuilder = vajramDef.facetsFromRequest(request);
            } else if (container instanceof FacetValues) {
                FacetValues facetValues = (FacetValues)container;
                facetsBuilder = facetValues._asBuilder();
            } else {
                throw new UnsupportedOperationException("Unknown facet container type " + container.getClass());
            }
            newRequests.put((Object)invocationId, (Object)this.injectFacetsOfVajram(vajramDefinition, injectableFacets, facetsBuilder));
        }
        return this.kryon.executeCommand((KryonCommand)new ForwardReceive(forwardBatch.vajramID(), newRequests.build(), forwardBatch.dependentChain(), forwardBatch.invocationsToSkip()));
    }

    private FacetValuesBuilder injectFacetsOfVajram(VajramDefinition vajramDefinition, Set<FacetSpec<?, ?>> injectableFacets, FacetValuesBuilder facetsBuilder) {
        for (FacetSpec<?, ?> facetSpec : injectableFacets) {
            DefaultFacetSpec defaultFacetSpec;
            Errable facetValue;
            if (!(facetSpec instanceof DefaultFacetSpec) || (facetValue = (defaultFacetSpec = (DefaultFacetSpec)facetSpec).getFacetValue((FacetValues)facetsBuilder)).valueOpt().isPresent()) continue;
            Errable<Object> injectedValue = this.getInjectedValue(vajramDefinition.vajramId(), facetSpec);
            if (injectedValue instanceof Success) {
                Success success = (Success)injectedValue;
                defaultFacetSpec.setFacetValue(facetsBuilder, (FacetValue)success);
                continue;
            }
            if (!(injectedValue instanceof Failure)) continue;
            Failure f = (Failure)injectedValue;
            log.error("Could not inject input {} of vajram {}", new Object[]{facetSpec, this.kryon.getKryonDefinition().vajramID().id(), f.error()});
        }
        return facetsBuilder;
    }

    private Errable<Object> getInjectedValue(VajramID vajramId, FacetSpec facetDef) {
        VajramInjectionProvider inputInjector = this.injectionProvider;
        if (inputInjector == null) {
            StackTracelessException exception = new StackTracelessException("Dependency injector is null");
            log.error("Cannot inject input {} of vajram {}", new Object[]{facetDef, this.kryon.getKryonDefinition().vajramID().id(), exception});
            return Errable.withError((Throwable)exception);
        }
        try {
            return inputInjector.get(vajramId, facetDef);
        }
        catch (Throwable e) {
            String message = "Could not inject input %s of vajram %s".formatted(facetDef, this.kryon.getKryonDefinition().vajramID().id());
            log.error(message, e);
            return Errable.withError((Throwable)e);
        }
    }
}

