/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.traits.PredicateDynamicDispatchPolicy;
import com.flipkart.krystal.traits.UseForDispatch;
import com.flipkart.krystal.traits.matchers.InputValueMatcher;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PredicateDispatchUtil {
    public static <T extends Request<?>> InputDispatcherBuilder<T> dispatchTrait(Class<T> traitReq, VajramKryonGraph graph) {
        Preconditions.checkArgument((traitReq.getAnnotation(TraitRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a trait request root i.e a request class with the annotation @TraitRequestRoot");
        return new InputDispatcherBuilder<T>(traitReq, graph);
    }

    public static <T extends Request<?>> DispatchCaseBuilder<T> when(InputMirrorSpec<?, T> input, InputValueMatcher inputValueMatcher) {
        Preconditions.checkArgument((boolean)input.tags().getAnnotationByType(UseForDispatch.class).isPresent(), (Object)"Only the trait Inputs annotated as @UseForDispatch can be used for dynamic dispatching");
        return new DispatchCaseBuilder((ImmutableMap<InputMirror, InputValueMatcher>)ImmutableMap.of(input, (Object)inputValueMatcher));
    }

    private PredicateDispatchUtil() {
    }

    public static class InputDispatcherBuilder<T extends Request<?>> {
        private final Class<T> traitReq;
        private final VajramKryonGraph graph;

        @SafeVarargs
        public final PredicateDynamicDispatchPolicy conditionally(DispatchCaseFinal<T> ... dispatchCases) {
            return new PredicateDynamicDispatchPolicy(this.graph.getVajramIdByVajramReqType(this.traitReq), (ImmutableList)Arrays.stream(dispatchCases).map(d -> new PredicateDynamicDispatchPolicy.DispatchCase(d.inputPredicates(), this.graph.getVajramIdByVajramReqType(d.dispatchTarget()))).collect(ImmutableList.toImmutableList()));
        }

        @Generated
        private InputDispatcherBuilder(Class<T> traitReq, VajramKryonGraph graph) {
            this.traitReq = traitReq;
            this.graph = graph;
        }
    }

    public static class DispatchCaseBuilder<T extends Request<?>> {
        private ImmutableMap<InputMirror, InputValueMatcher> facetPredicates;

        public DispatchCaseBuilder<T> and(InputMirror input, InputValueMatcher dataType) {
            Preconditions.checkArgument((!this.facetPredicates.containsKey((Object)input) ? 1 : 0) != 0, (Object)("Facet " + input + " already has a type check in this case"));
            LinkedHashMap<InputMirror, InputValueMatcher> newMap = new LinkedHashMap<InputMirror, InputValueMatcher>((Map<InputMirror, InputValueMatcher>)this.facetPredicates);
            newMap.put(input, dataType);
            return new DispatchCaseBuilder<T>((ImmutableMap<InputMirror, InputValueMatcher>)ImmutableMap.copyOf(newMap));
        }

        public DispatchCaseFinal<T> to(Class<? extends T> dispatchTarget) {
            Preconditions.checkArgument((dispatchTarget.getAnnotation(VajramRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a Vajram request root class, i.e. one with the @VajramRequestRoot annotation");
            return new DispatchCaseFinal<T>(this.facetPredicates, dispatchTarget);
        }

        @Generated
        private DispatchCaseBuilder(ImmutableMap<InputMirror, InputValueMatcher> facetPredicates) {
            this.facetPredicates = facetPredicates;
        }
    }

    public static final class DispatchCaseFinal<T extends Request<?>> {
        private final ImmutableMap<InputMirror, InputValueMatcher> inputPredicates;
        private final Class<? extends T> dispatchTarget;

        @Generated
        public ImmutableMap<InputMirror, InputValueMatcher> inputPredicates() {
            return this.inputPredicates;
        }

        @Generated
        public Class<? extends T> dispatchTarget() {
            return this.dispatchTarget;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DispatchCaseFinal)) {
                return false;
            }
            DispatchCaseFinal other = (DispatchCaseFinal)o;
            ImmutableMap<InputMirror, InputValueMatcher> this$inputPredicates = this.inputPredicates();
            ImmutableMap<InputMirror, InputValueMatcher> other$inputPredicates = other.inputPredicates();
            if (this$inputPredicates == null ? other$inputPredicates != null : !this$inputPredicates.equals(other$inputPredicates)) {
                return false;
            }
            Class<T> this$dispatchTarget = this.dispatchTarget();
            Class<T> other$dispatchTarget = other.dispatchTarget();
            return !(this$dispatchTarget == null ? other$dispatchTarget != null : !this$dispatchTarget.equals(other$dispatchTarget));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImmutableMap<InputMirror, InputValueMatcher> $inputPredicates = this.inputPredicates();
            result = result * 59 + ($inputPredicates == null ? 43 : $inputPredicates.hashCode());
            Class<T> $dispatchTarget = this.dispatchTarget();
            result = result * 59 + ($dispatchTarget == null ? 43 : $dispatchTarget.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "PredicateDispatchUtil.DispatchCaseFinal(inputPredicates=" + this.inputPredicates() + ", dispatchTarget=" + this.dispatchTarget() + ")";
        }

        @Generated
        private DispatchCaseFinal(ImmutableMap<InputMirror, InputValueMatcher> inputPredicates, Class<? extends T> dispatchTarget) {
            this.inputPredicates = inputPredicates;
            this.dispatchTarget = dispatchTarget;
        }
    }
}

