/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.traits.PredicateDynamicDispatchPolicy;
import com.flipkart.krystal.traits.UseForDispatch;
import com.flipkart.krystal.traits.matchers.InputValueMatcher;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PredicateDispatchUtil {
    public static <T extends Request<?>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputDispatcherBuilder<T> dispatchTrait(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<T> traitReq, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph graph) {
        Preconditions.checkArgument((traitReq.getAnnotation(TraitRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a trait request root i.e a request class with the annotation @TraitRequestRoot");
        return new InputDispatcherBuilder<T>(traitReq, graph);
    }

    public static <T extends Request<?>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DispatchCaseBuilder<T> when(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirrorSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?, T> input, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher inputValueMatcher) {
        Preconditions.checkArgument((boolean)input.tags().getAnnotationByType(UseForDispatch.class).isPresent(), (Object)"Only the trait Inputs annotated as @UseForDispatch can be used for dynamic dispatching");
        return new DispatchCaseBuilder((ImmutableMap<InputMirror, InputValueMatcher>)ImmutableMap.of(input, (Object)inputValueMatcher));
    }

    private PredicateDispatchUtil() {
    }

    public static class InputDispatcherBuilder<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<T> traitReq;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph graph;

        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PredicateDynamicDispatchPolicy conditionally(DispatchCaseFinal<T> ... dispatchCases) {
            return new PredicateDynamicDispatchPolicy(this.graph.getVajramIdByVajramReqType(this.traitReq), (ImmutableList)Arrays.stream(dispatchCases).map(d -> new PredicateDynamicDispatchPolicy.DispatchCase(d.inputPredicates(), this.graph.getVajramIdByVajramReqType(d.dispatchTarget()))).collect(ImmutableList.toImmutableList()));
        }

        @Generated
        private InputDispatcherBuilder(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<T> traitReq, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph graph) {
            this.traitReq = traitReq;
            this.graph = graph;
        }
    }

    public static class DispatchCaseBuilder<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> {
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher> facetPredicates;

        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DispatchCaseBuilder<T> and(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror input, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher dataType) {
            Preconditions.checkArgument((!this.facetPredicates.containsKey((Object)input) ? 1 : 0) != 0, (Object)("Facet " + input + " already has a type check in this case"));
            LinkedHashMap<InputMirror, InputValueMatcher> newMap = new LinkedHashMap<InputMirror, InputValueMatcher>((Map<InputMirror, InputValueMatcher>)this.facetPredicates);
            newMap.put(input, dataType);
            return new DispatchCaseBuilder<T>((ImmutableMap<InputMirror, InputValueMatcher>)ImmutableMap.copyOf(newMap));
        }

        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DispatchCaseFinal<T> to(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget) {
            Preconditions.checkArgument((dispatchTarget.getAnnotation(VajramRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a Vajram request root class, i.e. one with the @VajramRequestRoot annotation");
            return new DispatchCaseFinal<T>(this.facetPredicates, dispatchTarget);
        }

        @Generated
        private DispatchCaseBuilder(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher> facetPredicates) {
            this.facetPredicates = facetPredicates;
        }
    }

    public static final class DispatchCaseFinal<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher> inputPredicates;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget;

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher> inputPredicates() {
            return this.inputPredicates;
        }

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget() {
            return this.dispatchTarget;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean equals(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DispatchCaseFinal)) {
                return false;
            }
            DispatchCaseFinal other = (DispatchCaseFinal)o;
            ImmutableMap<InputMirror, InputValueMatcher> this$inputPredicates = this.inputPredicates();
            ImmutableMap<InputMirror, InputValueMatcher> other$inputPredicates = other.inputPredicates();
            if (this$inputPredicates == null ? other$inputPredicates != null : !this$inputPredicates.equals(other$inputPredicates)) {
                return false;
            }
            Class<T> this$dispatchTarget = this.dispatchTarget();
            Class<T> other$dispatchTarget = other.dispatchTarget();
            return !(this$dispatchTarget == null ? other$dispatchTarget != null : !this$dispatchTarget.equals(other$dispatchTarget));
        }

        @Pure
        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImmutableMap<InputMirror, InputValueMatcher> $inputPredicates = this.inputPredicates();
            result = result * 59 + ($inputPredicates == null ? 43 : $inputPredicates.hashCode());
            Class<T> $dispatchTarget = this.dispatchTarget();
            result = result * 59 + ($dispatchTarget == null ? 43 : $dispatchTarget.hashCode());
            return result;
        }

        @SideEffectFree
        @Generated
        public @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String toString() {
            return "PredicateDispatchUtil.DispatchCaseFinal(inputPredicates=" + this.inputPredicates() + ", dispatchTarget=" + this.dispatchTarget() + ")";
        }

        @Generated
        private DispatchCaseFinal(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher> inputPredicates, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget) {
            this.inputPredicates = inputPredicates;
            this.dispatchTarget = dispatchTarget;
        }
    }
}

