/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.traits.DispatchCase;
import com.flipkart.krystal.traits.PredicateDynamicDispatchPolicy;
import com.flipkart.krystal.traits.UseForDispatch;
import com.flipkart.krystal.traits.matchers.InputValueMatcher;
import com.flipkart.krystal.vajram.TraitRequestRoot;
import com.flipkart.krystal.vajram.VajramRequestRoot;
import com.flipkart.krystal.vajram.facets.specs.InputMirrorSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.traits.PredicateDispatchPolicyImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PredicateDispatchUtil {
    public static <R extends Request<?>> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputDispatcherBuilder<R> dispatchTrait(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<R> traitReq, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph graph) {
        Preconditions.checkArgument((traitReq.getAnnotation(TraitRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a trait request root i.e a request class with the annotation @TraitRequestRoot");
        return new InputDispatcherBuilder<R>(traitReq, graph);
    }

    public static <T, R> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DispatchCaseBuilder<R> when(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirrorSpec<T, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<R>> input, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<T> inputValueMatcher) {
        Preconditions.checkArgument((boolean)input.tags().getAnnotationByType(UseForDispatch.class).isPresent(), (Object)"Only the trait Inputs annotated as @UseForDispatch can be used for dynamic dispatching");
        return new DispatchCaseBuilder(ImmutableMap.of(input, inputValueMatcher));
    }

    private PredicateDispatchUtil() {
    }

    public static class InputDispatcherBuilder<@UnknownKeyFor R/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<R> traitReq;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph graph;

        @SafeVarargs
        public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PredicateDynamicDispatchPolicy conditionally(PredicatesDispatchCase<? extends Request<?>> ... dispatchCases) {
            return new PredicateDispatchPolicyImpl(this.traitReq, (ImmutableList<DispatchCase>)ImmutableList.copyOf((Object[])dispatchCases), this.graph);
        }

        public final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PredicateDispatchPolicyImpl computingTargetWith(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Function<@UnknownKeyFor @Nullable @Initialized @UnknownThis @CalledMethods(value={}) @NonLeaked @MaybeAliased @MaybePresent ? super R, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends R>>> dispatchTargetSelector, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends R>> dispatchTargets) {
            return new PredicateDispatchPolicyImpl(this.traitReq, (ImmutableList<DispatchCase>)ImmutableList.of(new ComputedDispatchCase<R>(dispatchTargetSelector, ImmutableSet.copyOf(dispatchTargets))), this.graph);
        }

        @Generated
        private InputDispatcherBuilder(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<R> traitReq, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramKryonGraph graph) {
            this.traitReq = traitReq;
            this.graph = graph;
        }
    }

    public static class DispatchCaseBuilder<@UnknownKeyFor T> {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> facetPredicates;

        public <P> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DispatchCaseBuilder<T> and(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirrorSpec<P, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<T>> input, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<P> dataType) {
            Preconditions.checkArgument((!this.facetPredicates.containsKey(input) ? 1 : 0) != 0, (Object)("Facet " + input + " already has a type check in this case"));
            LinkedHashMap newMap = new LinkedHashMap((Map<InputMirror, InputValueMatcher<?>>)this.facetPredicates);
            newMap.put((InputMirror)input, dataType);
            return new DispatchCaseBuilder<T>(ImmutableMap.copyOf(newMap));
        }

        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PredicatesDispatchCase<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<T>> to(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<T>> dispatchTarget) {
            Preconditions.checkArgument((dispatchTarget.getAnnotation(VajramRequestRoot.class) != null ? 1 : 0) != 0, (Object)"Expecting a Vajram request root class, i.e. one with the @VajramRequestRoot annotation");
            return new PredicatesDispatchCase<Request<T>>(this.facetPredicates, dispatchTarget);
        }

        @Generated
        private DispatchCaseBuilder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> facetPredicates) {
            this.facetPredicates = facetPredicates;
        }
    }

    private record ComputedDispatchCase<@UnknownKeyFor R/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>>(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Function<@UnknownKeyFor @Nullable @Initialized @UnknownThis @CalledMethods(value={}) @NonLeaked @MaybeAliased @MaybePresent ? super R, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends R>>> dispatchTargetSelector, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>>> dispatchTargets) implements DispatchCase
    {
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>>> computeDispatchTarget(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> request) {
            Optional<Class<R>> dispatchTarget = this.dispatchTargetSelector.apply(request);
            if (dispatchTarget.isPresent() && this.dispatchTargets.contains(dispatchTarget.get())) {
                return dispatchTarget;
            }
            return Optional.empty();
        }
    }

    public static final class PredicatesDispatchCase<@UnknownKeyFor T/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>>
    implements DispatchCase {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> inputPredicates;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget;

        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror> dispatchEnabledInputs() {
            return this.inputPredicates.keySet();
        }

        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T>> computeDispatchTarget(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> request) {
            boolean caseMatches = true;
            for (InputMirror dispatchEnabledInput : this.dispatchEnabledInputs()) {
                Object inputValue = dispatchEnabledInput.getFromRequest(request);
                if (((InputValueMatcher)this.inputPredicates().getOrDefault((Object)dispatchEnabledInput, (Object)InputValueMatcher.isAnyValue())).matches(inputValue)) continue;
                caseMatches = false;
                break;
            }
            if (caseMatches) {
                return Optional.of(this.dispatchTarget);
            }
            return Optional.empty();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Request<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>>> dispatchTargets() {
            return ImmutableSet.of(this.dispatchTarget);
        }

        @Generated
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> inputPredicates() {
            return this.inputPredicates;
        }

        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget() {
            return this.dispatchTarget;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean equals(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredicatesDispatchCase)) {
                return false;
            }
            PredicatesDispatchCase other = (PredicatesDispatchCase)o;
            ImmutableMap<InputMirror, InputValueMatcher<?>> this$inputPredicates = this.inputPredicates();
            ImmutableMap<InputMirror, InputValueMatcher<?>> other$inputPredicates = other.inputPredicates();
            if (this$inputPredicates == null ? other$inputPredicates != null : !this$inputPredicates.equals(other$inputPredicates)) {
                return false;
            }
            Class<T> this$dispatchTarget = this.dispatchTarget();
            Class<T> other$dispatchTarget = other.dispatchTarget();
            return !(this$dispatchTarget == null ? other$dispatchTarget != null : !this$dispatchTarget.equals(other$dispatchTarget));
        }

        @Pure
        @Generated
        public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImmutableMap<InputMirror, InputValueMatcher<?>> $inputPredicates = this.inputPredicates();
            result = result * 59 + ($inputPredicates == null ? 43 : $inputPredicates.hashCode());
            Class<T> $dispatchTarget = this.dispatchTarget();
            result = result * 59 + ($dispatchTarget == null ? 43 : $dispatchTarget.hashCode());
            return result;
        }

        @SideEffectFree
        @Generated
        public @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String toString() {
            return "PredicateDispatchUtil.PredicatesDispatchCase(inputPredicates=" + this.inputPredicates() + ", dispatchTarget=" + this.dispatchTarget() + ")";
        }

        @Generated
        private PredicatesDispatchCase(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableMap<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputMirror, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent InputValueMatcher<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> inputPredicates, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends T> dispatchTarget) {
            this.inputPredicates = inputPredicates;
            this.dispatchTarget = dispatchTarget;
        }
    }
}

