/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.datatypes.StandardJavaType;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.lattice.vajram.sdk.InvocableOutsideProcess;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.vajram.codegen.common.models.VajramCodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.protobuf3.Protobuf3;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.MapFieldType;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.OptionalFieldType;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.ProtoFieldType;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.ProtoScalarType;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.RepeatedFieldType;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.StandardProto3Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoGenUtils {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(ProtoGenUtils.class);
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProtoScalarType> JAVA_TO_PROTO_SCALAR_TYPES = ImmutableMap.builder().put((Object)StandardJavaType.BOOLEAN, (Object)ProtoScalarType.BOOL_P).put((Object)StandardJavaType.INT, (Object)ProtoScalarType.SINT32_P).put((Object)StandardJavaType.LONG, (Object)ProtoScalarType.SINT64_P).put((Object)StandardJavaType.FLOAT, (Object)ProtoScalarType.FLOAT_P).put((Object)StandardJavaType.DOUBLE, (Object)ProtoScalarType.DOUBLE_P).put((Object)StandardJavaType.STRING, (Object)ProtoScalarType.STRING_P).put((Object)StandardProto3Type.BYTE_STRING, (Object)ProtoScalarType.BYTES_P).build();

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String getSimpleClassName(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String canonicalClassName) {
        String typeName = canonicalClassName;
        if (typeName.contains(".")) {
            typeName = typeName.substring(typeName.lastIndexOf(46) + 1);
        }
        return typeName;
    }

    public static @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> getPackageName(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String responseTypeName) {
        int lastDotIndex = responseTypeName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(responseTypeName.substring(0, lastDotIndex));
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isProto3Applicable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramCodeGenUtility util) {
        TypeElement vajramClass = vajramInfo.vajramClassElem();
        InvocableOutsideProcess invocableOutsideProcess = vajramClass.getAnnotation(InvocableOutsideProcess.class);
        if (invocableOutsideProcess == null) {
            String message = "Skipping class '%s' since remote invocation is not enabled".formatted(vajramClass.getQualifiedName());
            util.codegenUtil().note((CharSequence)message);
            return false;
        }
        SupportedModelProtocols supportedSerdeProtocols = vajramClass.getAnnotation(SupportedModelProtocols.class);
        List<? extends TypeMirror> serializationProtocols = ProtoGenUtils.getSerializationProtocols(supportedSerdeProtocols, util);
        if (serializationProtocols.stream().noneMatch(serializationProtocol -> util.codegenUtil().isSameRawType(serializationProtocol, Protobuf3.class))) {
            String message = "Skipping class '%s' since Protobuf3 is not one of the intended serialization protocols : %s ".formatted(vajramClass.getQualifiedName(), serializationProtocols);
            util.codegenUtil().note((CharSequence)message);
            return false;
        }
        return true;
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Path createOutputDirectory(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Path sourceOutputLocation, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util) throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent IOException {
        try {
            Path protoRootDir;
            ArrayList<String> pathComponents = new ArrayList<String>();
            Path javaDir = null;
            while (sourceOutputLocation != null && sourceOutputLocation.getFileName() != null) {
                if (sourceOutputLocation.getFileName().toString().equals("java")) {
                    javaDir = sourceOutputLocation;
                    break;
                }
                Path parent = sourceOutputLocation.getParent();
                if (parent == null) break;
                pathComponents.add(0, sourceOutputLocation.getFileName().toString());
                sourceOutputLocation = parent;
            }
            if (javaDir == null) {
                throw util.errorAndThrow("Failed to find 'java' directory in the source path", new Element[0]);
            }
            Path rootDir = protoRootDir = ((Path)Preconditions.checkNotNull((Object)javaDir.getParent())).resolve("protobuf");
            for (String component : pathComponents) {
                rootDir = rootDir.resolve(component);
            }
            Files.createDirectories(rootDir, new FileAttribute[0]);
            log.info("Created protobuf output directory at: {}", (Object)rootDir);
            return rootDir;
        }
        catch (IOException e) {
            log.error("Error creating output directory", (Throwable)e);
            throw e;
        }
    }

    static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isProtoTypeScalar(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenType dataType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util) {
        if (util.isSameRawType(dataType.rawType().javaModelType(util.processingEnv()), Optional.class)) {
            CodeGenType innerType = (CodeGenType)dataType.typeParameters().get(0);
            return ProtoGenUtils.isProtoTypeScalar(innerType, util);
        }
        return JAVA_TO_PROTO_SCALAR_TYPES.containsKey(dataType);
    }

    static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isProtoTypeRepeated(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenType dataType) {
        return dataType.canonicalClassName().equals(List.class.getCanonicalName());
    }

    static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isProtoTypeMap(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenType dataType) {
        return dataType.canonicalClassName().equals(Map.class.getCanonicalName());
    }

    static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProtoFieldType getProtobufType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenType dataType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Element element) {
        ImmutableList typeParameters = dataType.typeParameters();
        if (util.isOptional(dataType.javaModelType(util.processingEnv()))) {
            return new OptionalFieldType(ProtoGenUtils.getProtobufType((CodeGenType)typeParameters.get(0), util, element), util, element);
        }
        if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
            if (typeParameters.isEmpty()) {
                throw util.errorAndThrow("Raw list types are not supported by protobuf", new Element[]{element});
            }
            return new RepeatedFieldType(ProtoGenUtils.getProtobufType((CodeGenType)typeParameters.get(0), util, element), util, element);
        }
        if (ProtoGenUtils.isProtoTypeMap(dataType)) {
            if (typeParameters.size() != 2) {
                throw util.errorAndThrow("Raw map types are not supported by protobuf", new Element[]{element});
            }
            return new MapFieldType(ProtoGenUtils.getProtobufType((CodeGenType)typeParameters.get(0), util, element), ProtoGenUtils.getProtobufType((CodeGenType)typeParameters.get(1), util, element), util, element);
        }
        if (JAVA_TO_PROTO_SCALAR_TYPES.containsKey(dataType)) {
            return JAVA_TO_PROTO_SCALAR_TYPES.get(dataType);
        }
        throw util.errorAndThrow(String.format("Unsupported data type: %s. Cannot map to a Protocol Buffers type.", dataType), new Element[]{element});
    }

    public static void validateReturnTypeForProtobuf(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util) {
        block3: {
            CodeGenType returnType;
            block2: {
                returnType = vajramInfo.lite().responseType();
                Element typeElement = Objects.requireNonNull(util.processingEnv().getTypeUtils().asElement(returnType.javaModelType(util.processingEnv())));
                SupportedModelProtocols supportedModelProtocols = typeElement.getAnnotation(SupportedModelProtocols.class);
                if (supportedModelProtocols == null) break block2;
                if (!util.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().noneMatch(t -> util.isSameRawType(t, Protobuf3.class))) break block3;
            }
            util.error(String.format("Vajram '%s' has return type '%s' which is not a supported model protocol. RPC methods must return a message type that is compatible with Protobuf3.", vajramInfo.vajramName(), returnType), new Element[]{vajramInfo.vajramClassElem()});
        }
    }

    static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeMirror> getSerializationProtocols(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent SupportedModelProtocols supportedSerdeProtocols, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramCodeGenUtility util) {
        return supportedSerdeProtocols == null ? List.of() : util.codegenUtil().getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedSerdeProtocols).value());
    }

    static void validateProtobufCompatibility(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util) {
        ProtoGenUtils.validateReturnTypeForProtobuf(vajramInfo, util);
    }

    @Generated
    private ProtoGenUtils() {
    }
}

