/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.data.IfNull;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaTypes;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.vajram.protobuf3.codegen.ModelsProto3SchemaGen;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsProto3Gen
implements CodeGenerator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(ModelsProto3Gen.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ModelsCodeGenContext codeGenContext;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util;

    public ModelsProto3Gen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ModelsCodeGenContext codeGenContext) {
        this.codeGenContext = codeGenContext;
        this.util = codeGenContext.util();
    }

    public void generate() {
        if (!this.isApplicable()) {
            return;
        }
        this.validate();
        this.generateProtoImplementation();
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isApplicable() {
        if (!CodegenPhase.FINAL.equals((Object)this.codeGenContext.codegenPhase())) {
            this.util.note((CharSequence)"Skipping protobuf codegen since current phase is not FINAL");
            return false;
        }
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelRoot modelRootAnnotation = modelRootType.getAnnotation(ModelRoot.class);
        if (modelRootAnnotation == null) {
            this.util.note((CharSequence)"Skipping class '%s' since it doesn't have @ModelRoot annotation".formatted(modelRootType.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void validate() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelsProto3SchemaGen.validateModelType(modelRootType, this.util);
    }

    private void generateProtoImplementation() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        String modelRootName = modelRootType.getSimpleName().toString();
        String packageName = this.util.processingEnv().getElementUtils().getPackageOf(modelRootType).toString();
        String protoClassName = modelRootName + "_ImmutProto";
        TypeSpec typeSpec = this.generateImplementationTypeSpec(modelRootType, packageName, protoClassName);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        this.util.generateSourceFile(packageName + "." + protoClassName, javaFile.toString(), modelRootType);
        log.info("Generated protobuf implementation class: {}", (Object)protoClassName);
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec generateImplementationTypeSpec(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement modelRootType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String protoClassName) {
        ClassName immutableProtoType = ClassName.get((String)packageName, (String)protoClassName, (String[])new String[0]);
        String modelRootName = modelRootType.getSimpleName().toString();
        String immutInterfaceName = modelRootName + "_Immut";
        String protoMsgClassName = modelRootName + "_Proto";
        List<ExecutableElement> modelMethods = this.extractModelMethods(modelRootType);
        AnnotationSpec suppressWarningsAnnotation = AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$L", new Object[]{"{\"unchecked\", \"ClassReferencesSubclass\"}"}).build();
        ClassName immutInterfaceClassName = ClassName.get((String)packageName, (String)immutInterfaceName, (String[])new String[0]);
        ClassName serializableClassName = ClassName.get(SerializableModel.class);
        ArrayTypeName byteArrayType = ArrayTypeName.of((TypeName)TypeName.BYTE);
        ClassName protoMsgType = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]);
        TypeName nullableProtoMsgType = protoMsgType.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()});
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)protoClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(suppressWarningsAnnotation).addSuperinterface((TypeName)immutInterfaceClassName).addSuperinterface((TypeName)serializableClassName);
        this.util.addGeneratedAnnotations(classBuilder);
        classBuilder.addField(FieldSpec.builder((TypeName)byteArrayType, (String)"_serializedPayload", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)nullableProtoMsgType, (String)"_proto", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)byteArrayType, "_serializedPayload", new Modifier[0]).addStatement("this._serializedPayload = _serializedPayload", new Object[0]).addStatement("this._proto = null", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)protoMsgType, "_proto", new Modifier[0]).addStatement("this._proto = _proto", new Object[0]).addStatement("this._serializedPayload = null", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_serialize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)byteArrayType).beginControlFlow("if (_serializedPayload == null)", new Object[0]).addStatement("this._serializedPayload = _proto.toByteArray()", new Object[0]).endControlFlow().addStatement("return _serializedPayload", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutInterfaceClassName).addStatement("return this", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return new Builder(_proto().toBuilder())", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutInterfaceClassName).addStatement("return new $L(_serializedPayload)", new Object[]{protoClassName}).build());
        MethodSpec.Builder getProtoMsgBuilder = MethodSpec.methodBuilder((String)"_proto").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)protoMsgType).beginControlFlow("if (_proto == null && _serializedPayload != null)", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("_proto = $T.parseFrom(_serializedPayload)", new Object[]{protoMsgType}).nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new RuntimeException(\"Failed to deserialize proto message\", e)", new Object[0]).endControlFlow().endControlFlow().beginControlFlow("if (_proto == null)", new Object[0]).addStatement("throw new IllegalStateException(\"Both _proto and _serializedPayload are null\")", new Object[0]).endControlFlow().addStatement("return _proto", new Object[0]);
        classBuilder.addMethod(getProtoMsgBuilder.build());
        for (ExecutableElement method : modelMethods) {
            String methodName = method.getSimpleName().toString();
            TypeMirror returnType = method.getReturnType();
            DataType dataType = (DataType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType);
            TypeName typeName = TypeName.get((TypeMirror)returnType);
            MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
            if (ModelsProto3Gen.needsPresenceCheckInModels(method) && !ModelsProto3Gen.isMandatoryField(method) && !this.util.isOptional(returnType)) {
                getterBuilder.returns(typeName.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}));
            } else {
                getterBuilder.returns(typeName);
            }
            this.addGetterCode(getterBuilder, method, dataType, methodName);
            classBuilder.addMethod(getterBuilder.build());
        }
        MethodSpec equalsMethod = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "obj", new Modifier[0]).addCode("if (this == obj) {\n  return true;\n}\nif (obj == null || getClass() != obj.getClass()) {\n  return false;\n}\n$L other = ($L) obj;\nreturn _proto().equals(other._proto());\n", new Object[]{protoClassName, protoClassName}).build();
        classBuilder.addMethod(equalsMethod);
        MethodSpec hashCodeMethod = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return _proto().hashCode()", new Object[0]).build();
        classBuilder.addMethod(hashCodeMethod);
        TypeSpec builderTypeSpec = this.generateBuilderTypeSpec(packageName, protoClassName, protoMsgClassName, immutInterfaceName, modelMethods);
        classBuilder.addType(builderTypeSpec);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)immutableProtoType.nestedClass("Builder")).addStatement("return new $T()", new Object[]{immutableProtoType.nestedClass("Builder")}).build());
        return classBuilder.build();
    }

    private void addGetterCode(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent MethodSpec.Builder getterBuilder, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> dataType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String methodName) {
        if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
            getterBuilder.addStatement("return _proto().get$LList()", new Object[]{ProtoGenUtils.capitalize(methodName)});
            return;
        }
        if (ProtoGenUtils.isProtoTypeMap(dataType)) {
            getterBuilder.addStatement("return _proto().get$LMap()", new Object[]{ProtoGenUtils.capitalize(methodName)});
            return;
        }
        boolean isOptionalReturnType = this.util.isOptional(method.getReturnType());
        if (ModelsProto3Gen.needsPresenceCheckInModels(method)) {
            CodeBlock protoPresenceCheck = CodeBlock.of((String)"if (!_proto().has$L()){\n", (Object[])new Object[]{ProtoGenUtils.capitalize(methodName)});
            if (ModelsProto3Gen.isMandatoryField(method)) {
                getterBuilder.addCode(protoPresenceCheck).addCode("  throw new IllegalStateException(\"Field $L is mandatory but has no value\");\n}\n", new Object[]{methodName});
            } else if (isOptionalReturnType) {
                getterBuilder.addCode(protoPresenceCheck).addCode("  return Optional.empty();\n}\n", new Object[0]);
            } else {
                getterBuilder.addCode(protoPresenceCheck).addCode("  return null;\n}\n", new Object[0]);
            }
        }
        if (isOptionalReturnType) {
            getterBuilder.addStatement("return Optional.of(_proto().get$L())", new Object[]{ProtoGenUtils.capitalize(methodName)});
        } else {
            getterBuilder.addStatement("return _proto().get$L()", new Object[]{ProtoGenUtils.capitalize(methodName)});
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeSpec generateBuilderTypeSpec(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String protoClassName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String protoMsgClassName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String immutInterfaceName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> modelMethods) {
        ClassName immutableProtoType = ClassName.get((String)packageName, (String)protoClassName, (String[])new String[0]);
        ClassName builderInterfaceClassName = ClassName.get((String)packageName, (String)immutInterfaceName, (String[])new String[0]).nestedClass("Builder");
        ClassName protoBuilderClassName = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]).nestedClass("Builder");
        ClassName protoMsgClassNameObj = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]);
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)builderInterfaceClassName);
        this.util.addGeneratedAnnotations(builderClassBuilder);
        builderClassBuilder.addField(FieldSpec.builder((TypeName)protoBuilderClassName, (String)"_proto", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)protoBuilderClassName, "_proto", new Modifier[0]).addStatement("this._proto = _proto", new Object[0]).build());
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this._proto = $T.newBuilder()", new Object[]{protoMsgClassNameObj}).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableProtoType).addStatement("return new $L(_proto.build())", new Object[]{protoClassName}).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return this", new Object[0]).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return new Builder(_proto.clone())", new Object[0]).build());
        for (ExecutableElement method : modelMethods) {
            TypeName typeName;
            String methodName = method.getSimpleName().toString();
            TypeMirror returnType = method.getReturnType();
            DataType dataType = (DataType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType);
            boolean isOptionalReturnType = this.util.isOptional(returnType);
            if (isOptionalReturnType) {
                TypeMirror innerType = this.util.getOptionalInnerType(returnType);
                typeName = TypeName.get((TypeMirror)innerType);
            } else {
                typeName = TypeName.get((TypeMirror)returnType);
            }
            if (typeName.isPrimitive()) {
                typeName = typeName.box();
            }
            MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0]));
            ParameterSpec.Builder paramBuilder = ParameterSpec.builder((TypeName)typeName, (String)methodName, (Modifier[])new Modifier[0]);
            paramBuilder.addAnnotation(Nullable.class);
            if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
                setterBuilder.addCode("  _proto.clear$L();\n  if ($L == null){\n    return this;\n  }\n  _proto.addAll$L($L);\n", new Object[]{ProtoGenUtils.capitalize(methodName), methodName, ProtoGenUtils.capitalize(methodName), methodName});
            } else if (ProtoGenUtils.isProtoTypeMap(dataType)) {
                setterBuilder.addCode("  _proto.clear$L();\n  if ($L == null){\n    return this;\n  }\n  _proto.putAll$L($L);\n", new Object[]{ProtoGenUtils.capitalize(methodName), methodName, ProtoGenUtils.capitalize(methodName), methodName});
            } else {
                setterBuilder.addCode("  if ($L == null){\n    _proto.clear$L();\n    return this;\n  }\n", new Object[]{methodName, ProtoGenUtils.capitalize(methodName)});
                setterBuilder.addStatement(dataType.equals(JavaTypes.BYTE) ? "_proto.set$L(com.google.protobuf.ByteString.copyFrom(new byte[]{$L}))" : "_proto.set$L($L)", new Object[]{ProtoGenUtils.capitalize(methodName), methodName});
            }
            setterBuilder.addStatement("return this", new Object[0]);
            builderClassBuilder.addMethod(setterBuilder.addParameter(paramBuilder.build()).build());
        }
        return builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_proto").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)protoBuilderClassName).addStatement("return _proto", new Object[0]).build()).build();
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> extractModelMethods(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement modelRootType) {
        ArrayList<ExecutableElement> modelMethods = new ArrayList<ExecutableElement>();
        for (Element element : modelRootType.getEnclosedElements()) {
            ExecutableElement method;
            if (!ElementKind.METHOD.equals((Object)element.getKind()) || (method = (ExecutableElement)element).getSimpleName().toString().equals("_build") || method.getSimpleName().toString().equals("_asBuilder") || method.getSimpleName().toString().equals("_newCopy") || !method.getParameters().isEmpty()) continue;
            modelMethods.add(method);
        }
        return modelMethods;
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean needsPresenceCheckInModels(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method) {
        IfNull ifNull = Utils.getIfNoValue((ExecutableElement)method);
        return ifNull.value() == IfNull.IfNullThen.FAIL || ifNull.value() == IfNull.IfNullThen.MAY_FAIL_CONDITIONALLY;
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isMandatoryField(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement method) {
        return Utils.getIfNoValue((ExecutableElement)method).value() == IfNull.IfNullThen.FAIL;
    }
}

