/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.serial.SerialId;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.DefaultFacetModel;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.spi.VajramCodeGenContext;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VajramModelsProto3SchemaGen
implements CodeGenerator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(VajramModelsProto3SchemaGen.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramCodeGenContext creationContext;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util;

    public VajramModelsProto3SchemaGen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramCodeGenContext creationContext) {
        this.creationContext = creationContext;
        this.util = creationContext.util();
    }

    public void generate() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramValidationException {
        if (!VajramModelsProto3SchemaGen.isApplicable(this.creationContext, this.util)) {
            return;
        }
        ProtoGenUtils.validateProtobufCompatibility(this.creationContext.vajramInfo(), this.util);
        this.generateProtobufSchema(this.creationContext.vajramInfo());
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isApplicable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramCodeGenContext creationContext, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CodeGenUtility util) {
        if (!CodegenPhase.MODELS.equals((Object)creationContext.codegenPhase())) {
            util.note((CharSequence)"Skipping protobuf codegen since current phase is not MODELS");
            return false;
        }
        return ProtoGenUtils.isProto3Applicable(creationContext.vajramInfo(), util);
    }

    private void generateProtobufSchema(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo) {
        String vajramName = vajramInfo.vajramClass().getSimpleName().toString();
        String packageName = vajramInfo.lite().packageName();
        String reqProtoFileName = vajramName + "_Req.models.proto";
        try {
            Path outputDir = ProtoGenUtils.createOutputDirectory(this.util.detectSourceOutputPath((Element)vajramInfo.vajramClass()), this.util);
            String reqProtoContent = this.generateRequestProtoFileContent(vajramInfo, packageName);
            Path reqProtoFilePath = outputDir.resolve(reqProtoFileName);
            try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(reqProtoFilePath, new OpenOption[0]));){
                out.println(reqProtoContent);
            }
            log.info("Generated request protobuf schema file: {}", (Object)reqProtoFilePath);
        }
        catch (IOException e) {
            this.util.error(String.format("Error generating protobuf schema for %s: %s", vajramName, e.getMessage()), new Element[]{vajramInfo.vajramClass()});
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String generateRequestProtoFileContent(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo vajramInfo, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName) {
        StringBuilder protoBuilder = new StringBuilder();
        String vajramId = vajramInfo.vajramName();
        String vajramClassName = vajramInfo.vajramClass().getQualifiedName().toString();
        protoBuilder.append("// AUTOMATICALLY GENERATED - DO NOT EDIT!\n").append("// This schema is auto-generated by Krystal's code generator.\n").append("// It models the request for Vajram with ID: ").append(vajramId).append("\n").append("// Source: ").append(vajramClassName).append("\n").append("// Any manual edits to this file will be overwritten.\n\n");
        protoBuilder.append("syntax = \"proto3\";\n\n");
        String currentPackageName = packageName;
        protoBuilder.append("package ").append(currentPackageName).append(";\n\n");
        protoBuilder.append("option java_package = \"").append(packageName).append("\";\n");
        protoBuilder.append("option java_multiple_files = true;\n");
        protoBuilder.append("option java_outer_classname = \"").append(vajramId).append("_Req_ModelsProto\";\n\n");
        protoBuilder.append("message ").append(vajramId).append("_Req_Proto {\n");
        HashSet<Integer> usedFieldNumbers = new HashSet<Integer>();
        for (DefaultFacetModel facet : vajramInfo.givenFacets().stream().filter(f -> f.facetType().equals((Object)FacetType.INPUT)).toList()) {
            String documentation;
            int fieldNumber;
            SerialId serialId = facet.facetField().getAnnotation(SerialId.class);
            if (serialId == null) {
                this.util.error(String.format("Missing @SerialId annotation on input '%s' in Vajram '%s'", facet.name(), vajramId), new Element[]{facet.facetField()});
                fieldNumber = -1;
            } else {
                fieldNumber = serialId.value();
            }
            if (fieldNumber <= 0) {
                this.util.error(String.format("Invalid SerialId %d for input '%s' in Vajram '%s'. SerialId must be positive.", fieldNumber, facet.name(), vajramId), new Element[]{facet.facetField()});
            }
            if (!usedFieldNumbers.add(fieldNumber)) {
                this.util.error(String.format("Duplicate SerialId %d for input '%s' in Vajram '%s'", fieldNumber, facet.name(), vajramId), new Element[]{facet.facetField()});
            }
            IfAbsent ifAbsent = facet.facetField().getAnnotation(IfAbsent.class);
            boolean isOptional = true;
            if (ifAbsent != null) {
                IfAbsent.IfAbsentThen ifAbsentThen = ifAbsent.value();
                TypeMirror rawType = this.util.processingEnv().getTypeUtils().erasure(facet.dataType().javaModelType(this.util.processingEnv()));
                boolean isRepeated = this.util.isRawAssignable(rawType, List.class);
                boolean isMap = this.util.isRawAssignable(rawType, Map.class);
                if (!ifAbsentThen.usePlatformDefault() && (isRepeated || isMap)) {
                    this.util.error(String.format("Input '%s' in Vajram '%s' is a %s field, and has @IfAbsent(%s) which is not supported in protobuf3. Use a different IfAbsent strategy or remove @IfAbsent annotation.", facet.name(), vajramId, isRepeated ? "repeated" : "map", ifAbsentThen), new Element[]{facet.facetField()});
                } else if (ifAbsentThen.usePlatformDefault()) {
                    isOptional = false;
                }
            }
            if ((documentation = facet.documentation()) != null && !documentation.trim().isEmpty()) {
                Iterable docLines = Splitter.on((char)'\n').split((CharSequence)documentation);
                for (String line : docLines) {
                    protoBuilder.append("  // ").append(line.trim()).append("\n");
                }
            }
            protoBuilder.append("  ");
            if (isOptional && ProtoGenUtils.isProtoTypeScalar(facet.dataType(), this.util) && !ProtoGenUtils.isProtoTypeRepeated(facet.dataType()) && !ProtoGenUtils.isProtoTypeMap(facet.dataType())) {
                protoBuilder.append("optional ");
            }
            protoBuilder.append(ProtoGenUtils.getProtobufType(facet.dataType(), this.util, facet.facetField()).typeInProtoFile()).append(" ").append(facet.name()).append(" = ").append(fieldNumber).append(";\n");
        }
        protoBuilder.append("}\n");
        return protoBuilder.toString();
    }
}

