/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.flipkart.krystal.vajram.inputs.InputId;
import com.flipkart.krystal.vajram.inputs.InputResolver;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ForwardingResolverV2<S, T>
implements InputResolver {
    private final String dependencyName;
    private final InputId<T> target;
    private final @Nullable InputId<S> source;
    private final Function<?, Collection<T>> usingValues;

    public static <T> ForwardingResolverV2<T, T> forwardResolve(String dependencyName, InputId<T> target, InputId<T> source) {
        return new ForwardingResolverV2<T, T>(dependencyName, target, source, o -> Set.of(o));
    }

    public static <S, T> ForwardingResolverV2<S, T> forwardResolveValue(String dependencyName, InputId<T> target, InputId<S> source, Function<S, T> using) {
        return new ForwardingResolverV2<S, T>(dependencyName, target, source, using.andThen(Collections::singleton));
    }

    public static <T> ForwardingResolverV2<Void, T> resolveValue(String dependencyName, InputId<T> target, Supplier<T> using) {
        return new ForwardingResolverV2(dependencyName, target, null, ((Function<Void, Object>)t -> using.get()).andThen(Collections::singleton));
    }

    public static <S, T> ForwardingResolverV2<S, T> forwardResolveValues(String dependencyName, InputId<T> target, InputId<S> source, Function<S, Collection<T>> using) {
        return new ForwardingResolverV2<S, T>(dependencyName, target, source, using);
    }

    @Override
    public ImmutableSet<String> sources() {
        if (this.source == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of((Object)this.source.inputName());
    }

    public Function<?, Collection<T>> transformationLogic() {
        if (this.usingValues == null) {
            return o -> Collections.emptyList();
        }
        return this.usingValues;
    }

    @Override
    public QualifiedInputs resolutionTarget() {
        return new QualifiedInputs(this.dependencyName, this.target.accessSpec(), this.target.inputName());
    }

    private ForwardingResolverV2(String dependencyName, InputId<T> target, @Nullable InputId<S> source, Function<?, Collection<T>> usingValues) {
        this.dependencyName = dependencyName;
        this.target = target;
        this.source = source;
        this.usingValues = usingValues;
    }
}

