/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.BindFrom;
import com.flipkart.krystal.vajram.inputs.DefaultInputResolver;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.InputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.flipkart.krystal.vajram.inputs.Resolve;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public final class VajramDefinition {
    private final Vajram<?> vajram;
    private final ImmutableCollection<InputResolverDefinition> inputResolverDefinitions;

    public VajramDefinition(Vajram<?> vajram) {
        this.vajram = vajram;
        this.inputResolverDefinitions = ImmutableList.copyOf(VajramDefinition.parseInputResolvers(vajram));
    }

    private static Collection<InputResolverDefinition> parseInputResolvers(Vajram<?> vajram) {
        ArrayList<InputResolverDefinition> inputResolvers = new ArrayList<InputResolverDefinition>((Collection<InputResolverDefinition>)vajram.getSimpleInputResolvers());
        ImmutableSet resolverMethods = (ImmutableSet)Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Resolve.class)).collect(ImmutableSet.toImmutableSet());
        ImmutableMap inputDefinitions = (ImmutableMap)vajram.getInputDefinitions().stream().filter(vi -> vi instanceof Dependency).map(vi -> (Dependency)vi).collect(ImmutableMap.toImmutableMap(VajramInputDefinition::name, Function.identity()));
        for (Method resolverMethod : resolverMethods) {
            Resolve resolver = resolverMethod.getAnnotation(Resolve.class);
            String targetDependency = resolver.value();
            Dependency dependency = (Dependency)inputDefinitions.get((Object)targetDependency);
            if (dependency == null) {
                throw new IllegalStateException("Could not find dependency with name %s".formatted(targetDependency));
            }
            Object[] targetInputs = resolver.inputs();
            ImmutableSet sources = (ImmutableSet)Arrays.stream(resolverMethod.getParameters()).map(Parameter::getAnnotations).map(annotations -> Arrays.stream(annotations).filter(annotation -> annotation instanceof BindFrom).map(annotation -> (BindFrom)annotation).findAny()).filter(Optional::isPresent).map(Optional::orElseThrow).toList().stream().map(BindFrom::value).collect(ImmutableSet.toImmutableSet());
            inputResolvers.add(new DefaultInputResolver((ImmutableSet<String>)sources, new QualifiedInputs(targetDependency, dependency.dataAccessSpec(), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])targetInputs))));
        }
        return inputResolvers;
    }

    private static Class<?> getVajramSourceClass(Class<?> vajramClass) {
        Class<?> superclass = vajramClass.getSuperclass();
        if (Object.class.equals(superclass)) {
            throw new IllegalArgumentException();
        }
        if (IOVajram.class.equals(superclass) || ComputeVajram.class.equals(superclass)) {
            return vajramClass;
        }
        return VajramDefinition.getVajramSourceClass(superclass);
    }

    public Vajram<?> getVajram() {
        return this.vajram;
    }

    public ImmutableCollection<InputResolverDefinition> getInputResolverDefinitions() {
        return this.inputResolverDefinitions;
    }
}

