/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DependencyCommand<T> {
    public ImmutableCollection<Optional<T>> inputs();

    public static <T> Skip<T> skip(String reason) {
        return new Skip(reason);
    }

    public static <T> Execute<T> executeWith(@Nullable T value) {
        return new Execute<T>(value);
    }

    public static <T> MultiExecute<T> multiExecuteWith(Collection<T> inputs) {
        return new MultiExecute(ImmutableList.copyOf(inputs));
    }

    public record Skip<T>(String reason) implements DependencyCommand<T>
    {
        @Override
        public ImmutableCollection<Optional<T>> inputs() {
            return ImmutableList.of();
        }

        public <U> Skip<U> cast() {
            return this;
        }
    }

    public record Execute<T>(T input) implements DependencyCommand<T>
    {
        @Override
        public ImmutableCollection<Optional<T>> inputs() {
            return ImmutableList.of(Optional.ofNullable(this.input));
        }
    }

    public record MultiExecute<T>(Collection<T> multiInputs) implements DependencyCommand<T>
    {
        @Override
        public ImmutableCollection<Optional<T>> inputs() {
            return (ImmutableCollection)this.multiInputs.stream().map(Optional::ofNullable).collect(ImmutableList.toImmutableList());
        }
    }
}

