/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.InputResolver;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;

record ForwardingResolver(String from, String dependencyName, String targetInputName, Function<Object, Object> using) implements InputResolver
{
    public static ForwardingResolverBuilder forwardResolve(String dependencyName, String targetInputName) {
        return ForwardingResolver.builder().dependencyName(dependencyName).targetInputName(targetInputName);
    }

    @Override
    public ImmutableSet<String> sources() {
        return ImmutableSet.of((Object)this.from);
    }

    public Function<Object, Collection<?>> transformationLogic() {
        return this.using.andThen(Collections::singleton);
    }

    @Override
    public QualifiedInputs resolutionTarget() {
        return new QualifiedInputs(this.dependencyName(), null, this.targetInputName());
    }

    @Override
    public DependencyCommand<Inputs> resolve(String dependencyName, ImmutableSet<String> inputsToResolve, Inputs inputs) {
        return DependencyCommand.executeWith(new Inputs(ImmutableMap.of((Object)this.targetInputName(), (Object)inputs.getInputValue(this.from()))));
    }

    public static ForwardingResolverBuilder builder() {
        return new ForwardingResolverBuilder();
    }

    public static class ForwardingResolverBuilder {
        private String from;
        private String dependencyName;
        private String targetInputName;
        private Function<Object, Object> using;

        ForwardingResolverBuilder() {
        }

        public ForwardingResolverBuilder from(String from) {
            this.from = from;
            return this;
        }

        public ForwardingResolverBuilder dependencyName(String dependencyName) {
            this.dependencyName = dependencyName;
            return this;
        }

        public ForwardingResolverBuilder targetInputName(String targetInputName) {
            this.targetInputName = targetInputName;
            return this;
        }

        public ForwardingResolverBuilder using(Function<Object, Object> using) {
            this.using = using;
            return this;
        }

        public ForwardingResolver build() {
            return new ForwardingResolver(this.from, this.dependencyName, this.targetInputName, this.using);
        }

        public String toString() {
            return "ForwardingResolver.ForwardingResolverBuilder(from=" + this.from + ", dependencyName=" + this.dependencyName + ", targetInputName=" + this.targetInputName + ", using=" + this.using + ")";
        }
    }
}

