/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram;

import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import java.util.Collection;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class VajramID
implements DataAccessSpec {
    private @MonotonicNonNull String vajramId;
    private final @MonotonicNonNull String className;

    private VajramID(String vajramId, String className) {
        this.vajramId = vajramId;
        this.className = className;
    }

    public static VajramID vajramID(String id) {
        return new VajramID(id, null);
    }

    public static VajramID fromClass(String vajramClassName) {
        return new VajramID(null, vajramClassName);
    }

    public String vajramId() {
        if (this.vajramId == null) {
            Optional<String> className = this.className();
            if (className.isPresent()) {
                try {
                    this.vajramId = Vajrams.getVajramIdString(this.getClass().getClassLoader().loadClass(className.get())).orElseThrow(() -> new IllegalStateException("Couldn't find vajram Id in vajram class %s".formatted(this.className)));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new IllegalStateException("Either 'vajramId' or 'className' must be non-null");
            }
        }
        return this.vajramId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VajramID)) {
            return false;
        }
        return this.vajramId().equals(((VajramID)obj).vajramId());
    }

    public int hashCode() {
        return this.vajramId().hashCode();
    }

    @Override
    public <T> T adapt(Collection<T> dataObjects) {
        throw new UnsupportedOperationException("");
    }

    public String toString() {
        return "v<%s>".formatted(this.vajramId());
    }

    private Optional<String> className() {
        return Optional.ofNullable(this.className);
    }
}

