/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.validators;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.inputs.BindFrom;
import com.flipkart.krystal.vajram.inputs.DefaultInputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.flipkart.krystal.vajram.inputs.Resolve;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Beta
public class ResolutionValidator {
    public static void main(String[] args) {
        Map<String, Class<? extends Vajram>> vajramsById = ResolutionValidator.discoverVajrams();
        ResolutionValidator resolutionValidator = new ResolutionValidator();
        ImmutableSet failures = (ImmutableSet)vajramsById.values().stream().map(aClass -> resolutionValidator.validateInputResolutions((Class<? extends Vajram>)aClass, true)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        if (failures.isEmpty()) {
            System.out.println("No errors in mandatory dependencies");
            failures = (ImmutableSet)vajramsById.values().stream().map(aClass -> resolutionValidator.validateInputResolutions((Class<? extends Vajram>)aClass, false)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            if (failures.isEmpty()) {
                System.out.println("No errors in optional dependencies");
            } else {
                System.out.println("Errors in optional dependencies");
                failures.forEach(System.out::println);
            }
        } else {
            System.out.println("Errors in mandatory dependencies:");
            failures.forEach(System.out::println);
        }
    }

    public List<String> validateInputResolutions(Class<? extends Vajram> vajramClass, boolean validateOnlyMandatory) {
        Map<String, Class<? extends Vajram>> vajramsById = ResolutionValidator.discoverVajrams();
        String vajramId = Vajrams.getVajramIdString(vajramClass).orElseThrow(() -> new NoSuchElementException("Vajram id missing in " + vajramClass));
        Vajram<?> vajram = this.createVajram(vajramClass);
        ImmutableCollection<VajramInputDefinition> inputDefinitions = vajram.getInputDefinitions();
        Map<QualifiedInputs, InputResolverDefinition> inputResolvers = this.getInputResolvers(vajramClass, vajram, inputDefinitions);
        ArrayList<String> result = new ArrayList<String>();
        inputDefinitions.forEach(input -> {
            Dependency resolvedInput;
            DataAccessSpec dataAccessSpec;
            if (input instanceof Dependency && (dataAccessSpec = (resolvedInput = (Dependency)input).dataAccessSpec()) instanceof VajramID) {
                VajramID vajramID = (VajramID)dataAccessSpec;
                String dependencyVajramId = vajramID.vajramId();
                Class dependency = (Class)vajramsById.get(dependencyVajramId);
                Stream<Input> unresolvedInputsOfDependencyStream = inputDefinitions.stream().filter(i -> i instanceof Input).map(i -> (Input)i).filter(unresolvedInput -> Set.of(InputSource.CLIENT).equals(unresolvedInput.sources()));
                if (validateOnlyMandatory) {
                    unresolvedInputsOfDependencyStream = unresolvedInputsOfDependencyStream.filter(unresolvedInput -> unresolvedInput.defaultValue() == null).filter(Input::isMandatory);
                }
                for (Input unresolvedInput2 : unresolvedInputsOfDependencyStream.toList()) {
                    if (inputResolvers.get(new QualifiedInputs(resolvedInput.name(), (DataAccessSpec)vajramID, unresolvedInput2.name())) != null) continue;
                    result.add("%s: Input Resolver missing for Unresolved input %s of input named %s of type %s".formatted(vajramId, unresolvedInput2.name(), resolvedInput.name(), dependencyVajramId));
                }
            }
        });
        return result;
    }

    private Vajram<?> createVajram(Class<? extends Vajram> vajramDefinition) {
        Vajram vajram;
        try {
            vajram = vajramDefinition.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Vajram");
        }
        return vajram;
    }

    private Map<QualifiedInputs, InputResolverDefinition> getInputResolvers(Class<? extends Vajram> vajramClass, Vajram<?> vajram, ImmutableCollection<VajramInputDefinition> inputDefinitions) {
        ImmutableMap collect = (ImmutableMap)inputDefinitions.stream().collect(ImmutableMap.toImmutableMap(VajramInputDefinition::name, Function.identity()));
        HashMap<QualifiedInputs, InputResolverDefinition> result = new HashMap<QualifiedInputs, InputResolverDefinition>();
        vajram.getSimpleInputResolvers().forEach(inputResolver -> {
            Dependency resolvedInput;
            DataAccessSpec dataAccessSpec;
            VajramInputDefinition vajramInputDefinition;
            QualifiedInputs qualifiedInputs = inputResolver.resolutionTarget();
            if (qualifiedInputs.spec() == null && (vajramInputDefinition = (VajramInputDefinition)collect.get((Object)qualifiedInputs.dependencyName())) instanceof Dependency && (dataAccessSpec = (resolvedInput = (Dependency)vajramInputDefinition).dataAccessSpec()) instanceof VajramID) {
                VajramID vajramID = (VajramID)dataAccessSpec;
                qualifiedInputs = new QualifiedInputs(qualifiedInputs.dependencyName(), (DataAccessSpec)vajramID, qualifiedInputs.inputNames());
            }
            result.put(qualifiedInputs, (InputResolverDefinition)inputResolver);
        });
        Arrays.stream(vajramClass.getMethods()).forEach(method -> {
            Resolve resolveDef = method.getAnnotation(Resolve.class);
            if (resolveDef != null && resolveDef.inputs().length > 0) {
                String dependencyName = resolveDef.value();
                String[] inputs = resolveDef.inputs();
                Arrays.stream(inputs).forEach(input -> {
                    Dependency dependency;
                    DataAccessSpec dataAccessSpec;
                    VajramInputDefinition vajramInputDefinition = (VajramInputDefinition)collect.get((Object)dependencyName);
                    if (vajramInputDefinition instanceof Dependency && (dataAccessSpec = (dependency = (Dependency)vajramInputDefinition).dataAccessSpec()) instanceof VajramID) {
                        VajramID vajramID = (VajramID)dataAccessSpec;
                        QualifiedInputs target = new QualifiedInputs(dependencyName, (DataAccessSpec)vajramID, (String)input);
                        ImmutableSet sources = (ImmutableSet)Arrays.stream(method.getParameters()).map(parameter -> parameter.getAnnotation(BindFrom.class)).filter(Objects::nonNull).map(BindFrom::value).collect(ImmutableSet.toImmutableSet());
                        result.put(target, new DefaultInputResolverDefinition((ImmutableSet<String>)sources, target));
                    }
                });
            }
        });
        return result;
    }

    private static Map<String, Class<? extends Vajram>> discoverVajrams() {
        HashMap<String, Class<? extends Vajram>> result = new HashMap<String, Class<? extends Vajram>>();
        new Reflections("com.flipkart", new Scanner[0]).getSubTypesOf(Vajram.class).forEach(aClass -> Vajrams.getVajramIdString(aClass).ifPresent(s -> result.put((String)s, (Class<? extends Vajram>)aClass)));
        return result;
    }
}

