/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public record Input<T>(String name, DataType type, boolean isMandatory, T defaultValue, String documentation, boolean needsModulation, ImmutableSet<InputSource> sources) implements VajramInputDefinition
{
    private final ImmutableSet<InputSource> sources;
    private static final ImmutableSet<InputSource> DEFAULT_INPUT_SOURCES = ImmutableSet.of((Object)((Object)InputSource.CLIENT));

    @Override
    public boolean isOptional() {
        return !this.isMandatory();
    }

    public ImmutableSet<InputSource> sources() {
        if (this.sources == null || this.sources.isEmpty()) {
            return DEFAULT_INPUT_SOURCES;
        }
        return this.sources;
    }

    public static <T> InputBuilder<T> builder() {
        return new InputBuilder();
    }

    public static class InputBuilder<T> {
        private String name;
        private DataType type;
        private boolean isMandatory;
        private T defaultValue;
        private String documentation;
        private boolean needsModulation;
        private ImmutableSet<InputSource> sources;

        public InputBuilder<T> isMandatory() {
            return this.mandatory(true);
        }

        public InputBuilder<T> mandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            return this;
        }

        public InputBuilder<T> needsModulation(boolean needsModulation) {
            this.needsModulation = needsModulation;
            return this;
        }

        public InputBuilder<T> needsModulation() {
            return this.needsModulation(true);
        }

        public InputBuilder<T> sources(InputSource ... inputSources) {
            if (inputSources != null) {
                this.sources = ImmutableSet.copyOf((Object[])inputSources);
            }
            return this;
        }

        public InputBuilder<T> sources(Set<InputSource> inputSources) {
            if (inputSources != null) {
                this.sources = ImmutableSet.copyOf(inputSources);
            }
            return this;
        }

        InputBuilder() {
        }

        public InputBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public InputBuilder<T> type(DataType type) {
            this.type = type;
            return this;
        }

        public InputBuilder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public InputBuilder<T> documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Input<T> build() {
            return new Input<T>(this.name, this.type, this.isMandatory, this.defaultValue, this.documentation, this.needsModulation, this.sources);
        }

        public String toString() {
            return "Input.InputBuilder(name=" + this.name + ", type=" + this.type + ", isMandatory=" + this.isMandatory + ", defaultValue=" + this.defaultValue + ", documentation=" + this.documentation + ", needsModulation=" + this.needsModulation + ", sources=" + this.sources + ")";
        }
    }
}

