/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DependencyCommand<T> {
    public static final String EMPTY_STRING = "";

    public ImmutableCollection<Optional<T>> inputs();

    public boolean shouldSkip();

    public String doc();

    public static <T> SingleExecute<T> singleExecuteWith(@Nullable T value) {
        return new SingleExecute<T>(value, false, EMPTY_STRING);
    }

    public static <T> MultiExecute<T> multiExecuteWith(Collection<T> inputs) {
        return new MultiExecute(ImmutableList.copyOf(inputs), false, EMPTY_STRING);
    }

    public record SingleExecute<T>(T input, boolean shouldSkip, String doc) implements DependencyCommand<T>
    {
        @Override
        public ImmutableCollection<Optional<T>> inputs() {
            return ImmutableList.of(Optional.ofNullable(this.input));
        }

        public static <T> SingleExecute<T> skipSingleExecute(String reason) {
            return new SingleExecute<Object>(null, true, reason);
        }
    }

    public record MultiExecute<T>(Collection<T> multiInputs, boolean shouldSkip, String doc) implements DependencyCommand<T>
    {
        @Override
        public ImmutableCollection<Optional<T>> inputs() {
            return (ImmutableCollection)this.multiInputs.stream().map(Optional::ofNullable).collect(ImmutableList.toImmutableList());
        }

        public static <T> MultiExecute<T> skipMultiExecute(String reason) {
            return new MultiExecute(Collections.emptyList(), true, reason);
        }
    }
}

