/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs.resolution;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.VajramDependencyTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.AbstractSimpleInputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverSpec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InputResolverUtil {
    static <S, T, CV extends Vajram<?>, DV extends Vajram<?>> DependencyCommand<Inputs> resolutionHelper(@Nullable VajramInputTypeSpec<S, CV> sourceInput, VajramInputTypeSpec<T, DV> targetInput, Function<S, T> oneToOneTransformer, List<SkipPredicate<S>> skipPredicates, Inputs inputs) {
        return InputResolverUtil._resolutionHelper(sourceInput, targetInput, oneToOneTransformer, null, skipPredicates, inputs);
    }

    static <S, T, CV extends Vajram<?>, DV extends Vajram<?>> DependencyCommand<Inputs> fanoutResolutionHelper(@Nullable VajramInputTypeSpec<S, CV> sourceInput, VajramInputTypeSpec<T, DV> targetInput, Function<S, ? extends Collection<? extends T>> fanoutTransformer, List<SkipPredicate<S>> skipPredicates, Inputs inputs) {
        return InputResolverUtil._resolutionHelper(sourceInput, targetInput, null, fanoutTransformer, skipPredicates, inputs);
    }

    private static <S, T, CV extends Vajram<?>, DV extends Vajram<?>> DependencyCommand<Inputs> _resolutionHelper(@Nullable VajramInputTypeSpec<S, CV> sourceInput, VajramInputTypeSpec<T, DV> targetInput, Function<S, T> oneToOneTransformer, Function<S, ? extends Collection<? extends T>> fanoutTransformer, List<SkipPredicate<S>> skipPredicates, Inputs inputs) {
        boolean fanout;
        boolean bl = fanout = fanoutTransformer != null;
        ValueOrError inputValue = sourceInput instanceof VajramDependencyTypeSpec ? (ValueOrError)inputs.getDepValue(sourceInput.name()).values().values().iterator().next() : (sourceInput != null ? inputs.getInputValue(sourceInput.name()) : ValueOrError.empty());
        Optional<SkipPredicate> skipPredicate = skipPredicates.stream().filter(sSkipPredicate -> {
            Optional value = inputValue.value();
            return sSkipPredicate.condition().test(value);
        }).findFirst();
        if (skipPredicate.isPresent()) {
            if (fanout) {
                return MultiExecute.skipFanout(skipPredicate.get().reason());
            }
            return SingleExecute.skipExecution(skipPredicate.get().reason());
        }
        Function<Object, Object> transformer = Optional.ofNullable(oneToOneTransformer).or(() -> Optional.ofNullable(fanoutTransformer).map(x -> x.andThen(ts -> ts))).orElse(Function.identity());
        Optional<Object> transformedInput = sourceInput == null ? Optional.ofNullable(transformer.apply(null)) : inputValue.value().map(t -> transformer.apply(t));
        Function<Object, Inputs> valueToInput = t -> new Inputs(ImmutableMap.of((Object)targetInput.name(), (Object)ValueOrError.withValue((Object)t)));
        if (fanout) {
            return MultiExecute.executeFanoutWith((Collection)transformedInput.map(ts -> ((Collection)ts).stream().map(valueToInput)).stream().flatMap(Function.identity()).collect(ImmutableList.toImmutableList()));
        }
        return SingleExecute.executeWith(transformedInput.map(o -> o).map(valueToInput).orElse(null));
    }

    static <S, T, CV extends Vajram<?>, DV extends Vajram<?>> InputResolver toResolver(VajramDependencyTypeSpec<?, CV, DV> dependency, final InputResolverSpec<S, T, CV, DV> spec) {
        return new AbstractSimpleInputResolver(dependency, spec.getTargetInput(), (List)ImmutableList.of(spec.getSourceInput())){

            @Override
            public DependencyCommand<Inputs> resolve(String dependencyName, ImmutableSet<String> inputsToResolve, Inputs inputs) {
                return InputResolverUtil._resolutionHelper(spec.getSourceInput(), spec.getTargetInput(), spec.getTransformer(), spec.getFanoutTransformer(), spec.getSkipConditions(), inputs);
            }
        };
    }

    private InputResolverUtil() {
    }

    record SkipPredicate<T>(String reason, Predicate<Optional<T>> condition) {
    }
}

