/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram;

import com.flipkart.krystal.vajram.VajramID;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class MandatoryInputsMissingException
extends RuntimeException {
    private final VajramID vajramID;
    private final ImmutableMap<String, Throwable> failedMandatoryInputs;
    private @MonotonicNonNull String detailedMessage;

    public MandatoryInputsMissingException(VajramID vajramID, Map<String, Throwable> failedMandatoryInputs) {
        this.vajramID = vajramID;
        this.failedMandatoryInputs = ImmutableMap.copyOf(failedMandatoryInputs);
    }

    @Override
    public String getMessage() {
        if (this.detailedMessage == null) {
            this.detailedMessage = this.createMessage();
        }
        return this.detailedMessage;
    }

    private String createMessage() {
        return "Vajram %s did not receive these mandatory inputs: [ %s ]".formatted(this.vajramID, String.join((CharSequence)", ", this.failedMandatoryInputs.keySet().stream().map(s -> "%s (Cause: %s)".formatted(s, ((Throwable)this.failedMandatoryInputs.getOrDefault(s, (Object)new RuntimeException())).getMessage())).toList()));
    }
}

