/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs.resolution;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.VajramDependencyTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.ResolutionRequest;
import com.flipkart.krystal.vajram.inputs.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.inputs.resolution.SkipPredicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class InputResolverUtil {
    public static ResolutionResult multiResolve(List<ResolutionRequest> resolutionRequests, Map<String, Collection<? extends SimpleInputResolver<?, ?, ?, ?>>> resolvers, Inputs inputs) {
        LinkedHashMap<String, List<Map<String, Object>>> results = new LinkedHashMap<String, List<Map<String, Object>>>();
        LinkedHashMap<String, DependencyCommand<Inputs>> skippedDependencies = new LinkedHashMap<String, DependencyCommand<Inputs>>();
        for (ResolutionRequest resolutionRequest : resolutionRequests) {
            String dependencyName = resolutionRequest.dependencyName();
            ArrayList<Map<String, Object>> depInputs = new ArrayList<Map<String, Object>>();
            Collection<SimpleInputResolver<?, ?, ?, ?>> depResolvers = resolvers.get(dependencyName);
            for (SimpleInputResolver<?, ?, ?, ?> simpleResolver : depResolvers) {
                String resolvable = simpleResolver.getResolverSpec().getTargetInput().name();
                DependencyCommand command = InputResolverUtil._resolutionHelper(simpleResolver.getResolverSpec().getSourceInput(), simpleResolver.getResolverSpec().getTransformer(), simpleResolver.getResolverSpec().getFanoutTransformer(), simpleResolver.getResolverSpec().getSkipConditions(), inputs);
                if (command.shouldSkip()) {
                    skippedDependencies.put(dependencyName, command);
                    break;
                }
                InputResolverUtil.collectDepInputs(depInputs, resolvable, command);
            }
            if (skippedDependencies.containsKey(dependencyName)) continue;
            results.putIfAbsent(dependencyName, depInputs);
        }
        return new ResolutionResult(results, skippedDependencies);
    }

    public static void collectDepInputs(List<Map<String, Object>> depInputs, String resolvable, DependencyCommand<?> command) {
        if (command.shouldSkip()) {
            return;
        }
        if (command instanceof SingleExecute) {
            SingleExecute singleExecute = (SingleExecute)command;
            if (depInputs.isEmpty()) {
                depInputs.add(new LinkedHashMap());
            }
            depInputs.forEach(map -> InputResolverUtil.handleResolverReturn(resolvable, singleExecute.input(), map));
        } else if (command instanceof MultiExecute) {
            MultiExecute multiExecute = (MultiExecute)command;
            Collection<Object> objects = multiExecute.multiInputs();
            if (depInputs.isEmpty()) {
                objects.forEach(o -> {
                    LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>();
                    depInputs.add(e);
                    InputResolverUtil.handleResolverReturn(resolvable, o, e);
                });
            } else {
                ArrayList<LinkedHashMap<String, Object>> more = new ArrayList<LinkedHashMap<String, Object>>(depInputs.size() * objects.size() - depInputs.size());
                for (Map<String, Object> depInput : depInputs) {
                    boolean first = true;
                    for (Object t : objects) {
                        if (first) {
                            first = false;
                            InputResolverUtil.handleResolverReturn(resolvable, t, depInput);
                            continue;
                        }
                        LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>(depInput);
                        more.add(e);
                        InputResolverUtil.handleResolverReturn(resolvable, t, e);
                    }
                }
                depInputs.addAll(more);
            }
        }
    }

    private static void handleResolverReturn(String resolvable, Object o, Map<String, Object> valuesMap) {
        if (o instanceof Inputs) {
            Inputs inputs = (Inputs)o;
            valuesMap.putAll(inputs.values().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ValueOrError)e.getValue()).value().orElse(null))));
        } else {
            valuesMap.put(resolvable, o);
        }
    }

    static <S, T, CV extends Vajram<?>, DV extends Vajram<?>> InputResolver toResolver(VajramDependencyTypeSpec<?, CV, DV> dependency, SimpleInputResolverSpec<S, T, CV, DV> spec) {
        return new SimpleInputResolver<S, T, CV, DV>(dependency, spec);
    }

    static <T> DependencyCommand<T> _resolutionHelper(VajramInputTypeSpec<?, ?> sourceInput, Function<? extends Optional<?>, ?> oneToOneTransformer, Function<? extends Optional<?>, ? extends Collection<?>> fanoutTransformer, List<? extends SkipPredicate<?>> skipPredicates, Inputs inputs) {
        boolean fanout;
        boolean bl = fanout = fanoutTransformer != null;
        ValueOrError inputValue = sourceInput instanceof VajramDependencyTypeSpec ? (ValueOrError)inputs.getDepValue(sourceInput.name()).values().values().iterator().next() : (sourceInput != null ? inputs.getInputValue(sourceInput.name()) : ValueOrError.empty());
        Optional<SkipPredicate> skipPredicate = skipPredicates.stream().map(p -> p).filter(sSkipPredicate -> sSkipPredicate.condition().test(inputValue.value())).findFirst();
        if (skipPredicate.isPresent()) {
            if (fanout) {
                return MultiExecute.skipFanout(skipPredicate.get().reason());
            }
            return SingleExecute.skipExecution(skipPredicate.get().reason());
        }
        Function<Optional, Object> transformer = Optional.ofNullable(oneToOneTransformer).or(() -> Optional.ofNullable(fanoutTransformer).map(function -> function.andThen(objects -> objects)).map(x -> x.andThen(Function.identity()))).orElse(Optional::orElseThrow);
        Optional<Object> transformedInput = sourceInput == null ? Optional.ofNullable(transformer.apply(Optional.empty())) : inputValue.value().map(t -> transformer.apply(Optional.of(t)));
        if (fanout) {
            return MultiExecute.executeFanoutWith((Collection)transformedInput.map(ts -> ((Collection)ts).stream()).stream().flatMap(Function.identity()).collect(ImmutableList.toImmutableList()));
        }
        return SingleExecute.executeWith(transformedInput.orElse(null));
    }

    private InputResolverUtil() {
    }

    public record ResolutionResult(Map<String, List<Map<String, Object>>> results, Map<String, DependencyCommand<Inputs>> skippedDependencies) {
    }
}

