/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;

public record Dependency<T>(String name, DataAccessSpec dataAccessSpec, boolean isMandatory, boolean canFanout, String documentation) implements VajramInputDefinition
{
    @Override
    public boolean needsModulation() {
        return false;
    }

    public static <T> DependencyBuilder<T> builder() {
        return new DependencyBuilder();
    }

    public static class DependencyBuilder<T> {
        private String name;
        private DataAccessSpec dataAccessSpec;
        private boolean isMandatory;
        private boolean canFanout;
        private String documentation;

        public DependencyBuilder<T> isMandatory() {
            return this.isMandatory(true);
        }

        public DependencyBuilder<T> isMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
            return this;
        }

        DependencyBuilder() {
        }

        public DependencyBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public DependencyBuilder<T> dataAccessSpec(DataAccessSpec dataAccessSpec) {
            this.dataAccessSpec = dataAccessSpec;
            return this;
        }

        public DependencyBuilder<T> canFanout(boolean canFanout) {
            this.canFanout = canFanout;
            return this;
        }

        public DependencyBuilder<T> documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Dependency<T> build() {
            return new Dependency(this.name, this.dataAccessSpec, this.isMandatory, this.canFanout, this.documentation);
        }

        public String toString() {
            return "Dependency.DependencyBuilder(name=" + this.name + ", dataAccessSpec=" + this.dataAccessSpec + ", isMandatory=" + this.isMandatory + ", canFanout=" + this.canFanout + ", documentation=" + this.documentation + ")";
        }
    }
}

