/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs.resolution;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.VajramDependencyTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.FanoutResolverStage;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverSpec;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.inputs.resolution.ResolverStage;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class InputResolvers {
    @SafeVarargs
    public static ImmutableList<InputResolver> resolve(List<InputResolver> ... inputResolvers) {
        return (ImmutableList)Arrays.stream(inputResolvers).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    @SafeVarargs
    public static <T, P, CV extends Vajram<?>, DV extends Vajram<T>> List<InputResolver> dep(VajramDependencyTypeSpec<T, P, CV, DV> dependency, InputResolverSpec<?, ?, CV, DV> ... resolverSpecs) {
        return Arrays.stream(resolverSpecs).map(spec -> InputResolverUtil.toResolver(dependency, spec)).toList();
    }

    public static <T, DV extends Vajram<?>> ResolverStage.ResolveStage<T, DV> depInput(VajramInputTypeSpec<T, DV> depInput) {
        return new ResolverStage.ResolveStage<T, DV>(depInput);
    }

    public static <T, DV extends Vajram<?>> FanoutResolverStage.ResolveFanoutStage<T, DV> fanout(VajramInputTypeSpec<T, DV> depInput) {
        return new FanoutResolverStage.ResolveFanoutStage<T, DV>(depInput);
    }

    public static <T, CV extends Vajram<?>, DV extends Vajram<?>> FanoutResolverStage.ResolveFanoutStage<T, DV> resolveFanout(VajramInputTypeSpec<T, DV> depInput) {
        return new FanoutResolverStage.ResolveFanoutStage<T, DV>(depInput);
    }

    private InputResolvers() {
    }
}

