/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs.resolution;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverSpec;
import com.flipkart.krystal.vajram.inputs.resolution.internal.SkipPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ResolverStage<S, T, CV extends Vajram<?>, DV extends Vajram<?>> {
    private final VajramInputTypeSpec<T, DV> targetInput;
    private final VajramInputTypeSpec<S, CV> sourceInput;
    private final List<SkipPredicate<S>> skipConditions = new ArrayList<SkipPredicate<S>>();

    ResolverStage(VajramInputTypeSpec<T, DV> targetInput, VajramInputTypeSpec<S, CV> sourceInput) {
        this.targetInput = targetInput;
        this.sourceInput = sourceInput;
    }

    public ResolverStage<S, T, CV, DV> skipIf(Predicate<Optional<S>> whenToSkip, String reason) {
        this.skipConditions.add(new SkipPredicate(reason, whenToSkip));
        return this;
    }

    public InputResolverSpec<S, T, CV, DV> with(Function<Optional<S>, T> transformer) {
        return new InputResolverSpec<S, T, CV, DV>(this.targetInput, this.sourceInput, this.skipConditions, transformer, null);
    }

    public static final class ResolveStage<T, DV extends Vajram<?>> {
        private final VajramInputTypeSpec<T, DV> targetInput;

        ResolveStage(VajramInputTypeSpec<T, DV> targetInput) {
            this.targetInput = targetInput;
        }

        public <CV extends Vajram<?>> AsIsResolverStage<T, CV, DV> usingAsIs(VajramInputTypeSpec<T, CV> sourceInput) {
            return new AsIsResolverStage<T, CV, DV>(this.targetInput, sourceInput);
        }

        public <S, CV extends Vajram<?>> ResolverStage<S, T, CV, DV> using(VajramInputTypeSpec<S, CV> sourceInput) {
            return new ResolverStage<S, T, CV, DV>(this.targetInput, sourceInput);
        }

        public <CV extends Vajram<?>> InputResolverSpec<Void, T, CV, DV> with(Supplier<T> with) {
            return new InputResolverSpec(this.targetInput, null, List.of(), o -> with.get(), null);
        }
    }

    public static final class AsIsResolverStage<T, CV extends Vajram<?>, DV extends Vajram<?>>
    extends ResolverStage<T, T, CV, DV> {
        AsIsResolverStage(VajramInputTypeSpec<T, DV> targetInput, VajramInputTypeSpec<T, CV> sourceInput) {
            super(targetInput, sourceInput);
        }

        public AsIsResolverStage<T, CV, DV> skipIf(Predicate<Optional<T>> whenToSkip, String reason) {
            this.skipConditions.add(new SkipPredicate<T>(reason, whenToSkip));
            return this;
        }

        public InputResolverSpec<T, T, CV, DV> asResolver() {
            return this.with(t -> t.orElse(null));
        }
    }
}

