/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.modulation;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class Batcher<I, C>
implements InputModulator<I, C> {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private Consumer<ImmutableList<ModulatedInput<I, C>>> modulationListener;
    private final Map<C, List<I>> unModulatedRequests = new HashMap<C, List<I>>();
    private int minBatchSize = 1;

    public Batcher() {
    }

    public Batcher(int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public ImmutableList<ModulatedInput<I, C>> add(I inputsNeedingModulation, C commonInputs) {
        this.unModulatedRequests.computeIfAbsent(commonInputs, k -> new ArrayList()).add(inputsNeedingModulation);
        return this.getModulatedInputs(commonInputs, false);
    }

    private ImmutableList<ModulatedInput<I, C>> getModulatedInputs(C commonInputs, boolean force) {
        ImmutableList inputsNeedingModulations = ImmutableList.copyOf((Collection)this.unModulatedRequests.get(commonInputs));
        if (force || inputsNeedingModulations.size() >= this.minBatchSize) {
            this.unModulatedRequests.put(commonInputs, new ArrayList());
            return ImmutableList.of(new ModulatedInput(inputsNeedingModulations, commonInputs));
        }
        return ImmutableList.of();
    }

    @Override
    public void modulate() {
        ImmutableList modulatedInputs = (ImmutableList)this.unModulatedRequests.keySet().stream().map(c -> this.getModulatedInputs(c, true)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.modulationListener != null) {
            this.modulationListener.accept(modulatedInputs);
        }
    }

    @Override
    public void onModulation(Consumer<ImmutableList<ModulatedInput<I, C>>> listener) {
        this.modulationListener = listener;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

