/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public record Input<@UnknownKeyFor T>(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized DataType type, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tag> tags, @UnknownKeyFor @NonNull @Initialized boolean isMandatory, T defaultValue, @UnknownKeyFor @NonNull @Initialized String documentation, @UnknownKeyFor @NonNull @Initialized boolean needsModulation, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized InputSource> sources) implements VajramInputDefinition
{
    private final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized InputSource> sources;
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized InputSource> DEFAULT_INPUT_SOURCES = ImmutableSet.of((Object)((Object)InputSource.CLIENT));

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isOptional() {
        return !this.isMandatory();
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized InputSource> sources() {
        if (this.sources == null || this.sources.isEmpty()) {
            return DEFAULT_INPUT_SOURCES;
        }
        return this.sources;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized InputBuilder<T> builder() {
        return new InputBuilder();
    }

    public static class InputBuilder<@UnknownKeyFor T> {
        private @UnknownKeyFor @NonNull @Initialized String name;
        private @UnknownKeyFor @NonNull @Initialized DataType type;
        private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tag> tags;
        private @UnknownKeyFor @NonNull @Initialized boolean isMandatory;
        private T defaultValue;
        private @UnknownKeyFor @NonNull @Initialized String documentation;
        private @UnknownKeyFor @NonNull @Initialized boolean needsModulation;
        private @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized InputSource> sources;

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> isMandatory() {
            return this.mandatory(true);
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> mandatory(@UnknownKeyFor @NonNull @Initialized boolean isMandatory) {
            this.isMandatory = isMandatory;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> needsModulation(@UnknownKeyFor @NonNull @Initialized boolean needsModulation) {
            this.needsModulation = needsModulation;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> needsModulation() {
            return this.needsModulation(true);
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> sources(InputSource ... inputSources) {
            if (inputSources != null) {
                this.sources = ImmutableSet.copyOf((Object[])inputSources);
            }
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> sources(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized InputSource> inputSources) {
            if (inputSources != null) {
                this.sources = ImmutableSet.copyOf(inputSources);
            }
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> tags(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags) {
            HashMap tagsMap = new HashMap();
            tags.forEach((key, value) -> tagsMap.put(key, new Tag(key, value)));
            this.tags = ImmutableMap.copyOf(tagsMap);
            return this;
        }

        InputBuilder() {
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> name(@UnknownKeyFor @NonNull @Initialized String name) {
            this.name = name;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> type(@UnknownKeyFor @NonNull @Initialized DataType type) {
            this.type = type;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InputBuilder<T> documentation(@UnknownKeyFor @NonNull @Initialized String documentation) {
            this.documentation = documentation;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Input<T> build() {
            return new Input<T>(this.name, this.type, this.tags, this.isMandatory, this.defaultValue, this.documentation, this.needsModulation, this.sources);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "Input.InputBuilder(name=" + this.name + ", type=" + this.type + ", tags=" + this.tags + ", isMandatory=" + this.isMandatory + ", defaultValue=" + this.defaultValue + ", documentation=" + this.documentation + ", needsModulation=" + this.needsModulation + ", sources=" + this.sources + ")";
        }
    }
}

