/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.TagWith;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramLogic;
import com.flipkart.krystal.vajram.inputs.DefaultInputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.flipkart.krystal.vajram.inputs.Using;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.resolution.Resolve;
import com.flipkart.krystal.vajram.tags.Service;
import com.flipkart.krystal.vajram.tags.ServiceApi;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class VajramDefinition {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized InputResolverDefinition> inputResolverDefinitions;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tag> mainLogicTags;

    public VajramDefinition(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        this.vajram = vajram;
        this.inputResolverDefinitions = ImmutableList.copyOf(VajramDefinition.parseInputResolvers(vajram));
        this.mainLogicTags = VajramDefinition.parseVajramLogicTags(vajram);
    }

    private static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized InputResolverDefinition> parseInputResolvers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        ArrayList<InputResolverDefinition> inputResolvers = new ArrayList<InputResolverDefinition>((Collection<InputResolverDefinition>)vajram.getSimpleInputResolvers());
        ImmutableSet resolverMethods = (ImmutableSet)Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Resolve.class)).collect(ImmutableSet.toImmutableSet());
        ImmutableMap inputDefinitions = (ImmutableMap)vajram.getInputDefinitions().stream().filter(vi -> vi instanceof Dependency).map(vi -> (Dependency)vi).collect(ImmutableMap.toImmutableMap(VajramInputDefinition::name, Function.identity()));
        for (Method resolverMethod : resolverMethods) {
            Resolve resolver = resolverMethod.getAnnotation(Resolve.class);
            if (resolver == null) {
                throw new AssertionError();
            }
            String targetDependency = resolver.depName();
            Dependency dependency = (Dependency)inputDefinitions.get((Object)targetDependency);
            if (dependency == null) {
                throw new IllegalStateException("Could not find dependency with name %s".formatted(targetDependency));
            }
            Object[] targetInputs = resolver.depInputs();
            ImmutableSet sources = (ImmutableSet)Arrays.stream(resolverMethod.getParameters()).map(Parameter::getAnnotations).map(annotations -> Arrays.stream(annotations).filter(annotation -> annotation instanceof Using).map(annotation -> (Using)annotation).findAny()).filter(Optional::isPresent).map(Optional::orElseThrow).toList().stream().map(Using::value).collect(ImmutableSet.toImmutableSet());
            inputResolvers.add(new DefaultInputResolverDefinition((ImmutableSet<String>)sources, new QualifiedInputs(targetDependency, dependency.dataAccessSpec(), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])targetInputs))));
        }
        return inputResolvers;
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tag> parseVajramLogicTags(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        Optional<Method> vajramLogicMethod = Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(VajramLogic.class) != null).findFirst();
        TagWith[] tagWithArray = vajramLogicMethod.map(method -> (TagWith[])method.getAnnotationsByType(TagWith.class)).orElse(new TagWith[0]);
        Map<String, Tag> collect = Arrays.stream(tagWithArray).collect(Collectors.toMap(TagWith::name, tagWith -> new Tag(tagWith.name(), tagWith.value())));
        vajramLogicMethod.ifPresent(method -> {
            ServiceApi serviceApi;
            Service service = method.getAnnotation(Service.class);
            if (service != null) {
                collect.put("service", new Tag("service", service.value()));
            }
            if ((serviceApi = method.getAnnotation(ServiceApi.class)) != null) {
                collect.put("service_api", new Tag("service_api", serviceApi.apiName()));
            }
            collect.put("vajram_type", new Tag("vajram_type", vajram instanceof IOVajram ? "io_vajram" : "compute_vajram"));
        });
        collect.put("vajram_id", new Tag("vajram_id", vajram.getId().vajramId()));
        return ImmutableMap.copyOf(collect);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getVajramSourceClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajramClass) {
        Class<?> superclass = vajramClass.getSuperclass();
        if (Object.class.equals(superclass) || superclass == null) {
            throw new IllegalArgumentException();
        }
        if (IOVajram.class.equals(superclass) || ComputeVajram.class.equals(superclass)) {
            return vajramClass;
        }
        return VajramDefinition.getVajramSourceClass(superclass);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getVajram() {
        return this.vajram;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized InputResolverDefinition> getInputResolverDefinitions() {
        return this.inputResolverDefinitions;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Tag> getMainLogicTags() {
        return this.mainLogicTags;
    }
}

