/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram;

import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import java.util.Collection;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class VajramID
implements DataAccessSpec {
    private @MonotonicNonNull @UnknownKeyFor @Initialized String vajramId;
    private final @MonotonicNonNull @UnknownKeyFor @Initialized String className;

    private VajramID(@Nullable @UnknownKeyFor @Initialized String vajramId, @Nullable @UnknownKeyFor @Initialized String className) {
        this.vajramId = vajramId;
        this.className = className;
    }

    public static @UnknownKeyFor @NonNull @Initialized VajramID vajramID(@UnknownKeyFor @NonNull @Initialized String id) {
        return new VajramID(id, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized VajramID fromClass(@UnknownKeyFor @NonNull @Initialized String vajramClassName) {
        return new VajramID(null, vajramClassName);
    }

    public @UnknownKeyFor @NonNull @Initialized String vajramId() {
        if (this.vajramId == null) {
            Optional<String> className = this.className();
            if (className.isPresent()) {
                try {
                    this.vajramId = Vajrams.getVajramIdString(Optional.ofNullable(this.getClass().getClassLoader()).orElseThrow().loadClass(className.get())).orElseThrow(() -> new IllegalStateException("Couldn't find vajram Id in vajram class %s".formatted(className.get())));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new IllegalStateException("Either 'vajramId' or 'className' must be non-null");
            }
        }
        return this.vajramId;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VajramID)) {
            return false;
        }
        return this.vajramId().equals(((VajramID)obj).vajramId());
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.vajramId().hashCode();
    }

    @Override
    public <T> T adapt(@UnknownKeyFor @NonNull @Initialized Collection<T> dataObjects) {
        throw new UnsupportedOperationException("");
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "v<%s>".formatted(this.vajramId());
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> className() {
        return Optional.ofNullable(this.className);
    }
}

