/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.das;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.das.AccessSpecIndex;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.GraphQl;
import com.flipkart.krystal.vajram.das.GraphQlIndex;
import com.flipkart.krystal.vajram.das.VajramIDIndex;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class VajramIndex {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataAccessSpec>> SUPPORTED_ACCESS_SPECS = Set.of(VajramID.class, GraphQl.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataAccessSpec>, @UnknownKeyFor @NonNull @Initialized AccessSpecIndex<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataAccessSpec>> accessSpecIndices = new HashMap<Class<? extends DataAccessSpec>, AccessSpecIndex<? extends DataAccessSpec>>();

    public VajramIndex() {
        SUPPORTED_ACCESS_SPECS.forEach(aClass -> {
            if (VajramID.class.equals(aClass)) {
                this.accessSpecIndices.put(VajramID.class, new VajramIDIndex());
            } else if (GraphQl.class.equals(aClass)) {
                this.accessSpecIndices.put(GraphQl.class, new GraphQlIndex());
            }
        });
    }

    public <T extends DataAccessSpec> @UnknownKeyFor @NonNull @Initialized AccessSpecMatchingResult<T> getVajrams(T accessSpec) {
        return Optional.ofNullable(this.accessSpecIndices.get(accessSpec.getClass())).map(index -> index.getVajrams(accessSpec)).orElse(new AccessSpecMatchingResult(ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(accessSpec)));
    }

    public void add(@UnknownKeyFor @NonNull @Initialized Vajram vajram) {
        this.accessSpecIndices.values().forEach(accessSpecIndex -> accessSpecIndex.add(vajram));
    }
}

