/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.modulation;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.ModulatedFacets;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class Batcher<@UnknownKeyFor I, @UnknownKeyFor C>
implements InputModulator<I, C> {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BATCH_SIZE = 1;
    private @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ModulatedFacets<I, C>>> modulationListener;
    private final @UnknownKeyFor @NonNull @Initialized Map<C, @UnknownKeyFor @NonNull @Initialized List<I>> unModulatedRequests = new HashMap<C, List<I>>();
    private @UnknownKeyFor @NonNull @Initialized int minBatchSize = 1;

    public Batcher() {
    }

    public Batcher(@UnknownKeyFor @NonNull @Initialized int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ModulatedFacets<I, C>> add(I inputsNeedingModulation, C commonInputs) {
        this.unModulatedRequests.computeIfAbsent(commonInputs, k -> new ArrayList()).add(inputsNeedingModulation);
        return this.getModulatedInputs(commonInputs, false);
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ModulatedFacets<I, C>> getModulatedInputs(C commonInputs, @UnknownKeyFor @NonNull @Initialized boolean force) {
        if (commonInputs == null) {
            return ImmutableList.of();
        }
        ImmutableList inputsNeedingModulations = ImmutableList.copyOf((Collection)((Collection)this.unModulatedRequests.getOrDefault(commonInputs, (List<I>)ImmutableList.of())));
        if (force || inputsNeedingModulations.size() >= this.minBatchSize) {
            this.unModulatedRequests.put(commonInputs, new ArrayList());
            return ImmutableList.of(new ModulatedFacets(inputsNeedingModulations, commonInputs));
        }
        return ImmutableList.of();
    }

    @Override
    public void modulate() {
        ImmutableList modulatedFacets = (ImmutableList)this.unModulatedRequests.keySet().stream().map(c -> this.getModulatedInputs(c, true)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.modulationListener != null) {
            this.modulationListener.accept(modulatedFacets);
        }
    }

    @Override
    public void onModulation(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ModulatedFacets<I, C>>> listener) {
        this.modulationListener = listener;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

