/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.Output;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.facets.DefaultInputResolverDefinition;
import com.flipkart.krystal.vajram.facets.DependencyDef;
import com.flipkart.krystal.vajram.facets.QualifiedInputs;
import com.flipkart.krystal.vajram.facets.Using;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverDefinition;
import com.flipkart.krystal.vajram.facets.resolution.sdk.Resolve;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajram.tags.Service;
import com.flipkart.krystal.vajram.tags.ServiceApi;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VajramDefinition {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(VajramDefinition.class);
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized InputResolverDefinition> inputResolverDefinitions;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag> outputLogicTags;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag>> facetTags;

    public VajramDefinition(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        this.vajram = vajram;
        this.inputResolverDefinitions = ImmutableList.copyOf(VajramDefinition.parseInputResolvers(vajram));
        this.outputLogicTags = VajramDefinition.parseOutputLogicTags(vajram);
        this.facetTags = VajramDefinition.parseFacetTags(vajram);
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag>> parseFacetTags(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        LinkedHashMap<String, ImmutableMap> result = new LinkedHashMap<String, ImmutableMap>();
        for (Field declaredField : vajram.getClass().getDeclaredFields()) {
            Annotation[] annotations;
            LinkedHashMap<Object, AnnotationTag<Annotation>> annoTags = new LinkedHashMap<Object, AnnotationTag<Annotation>>();
            for (Annotation annotation : annotations = declaredField.getAnnotations()) {
                boolean isRepeatable;
                boolean bl = isRepeatable = annotation.getClass().getAnnotation(Repeatable.class) != null;
                if (isRepeatable) {
                    log.warn("Repeatable annotations are not supported as tags. Ignoring {}", (Object)annotation);
                    continue;
                }
                AnnotationTag<Annotation> annotationTag = AnnotationTag.from(annotation);
                annoTags.put(annotationTag.tagKey(), annotationTag);
            }
            result.put(declaredField.getName(), ImmutableMap.copyOf(annoTags));
        }
        return ImmutableMap.copyOf(result);
    }

    private static @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized InputResolverDefinition> parseInputResolvers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        ArrayList<InputResolverDefinition> inputResolvers = new ArrayList<InputResolverDefinition>((Collection<InputResolverDefinition>)vajram.getSimpleInputResolvers());
        ImmutableSet resolverMethods = (ImmutableSet)Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Resolve.class)).collect(ImmutableSet.toImmutableSet());
        ImmutableMap dependencyDefinitions = (ImmutableMap)vajram.getFacetDefinitions().stream().filter(vi -> vi instanceof DependencyDef).map(vi -> (DependencyDef)vi).collect(ImmutableMap.toImmutableMap(VajramFacetDefinition::name, Function.identity()));
        for (Method resolverMethod : resolverMethods) {
            Resolve resolver = resolverMethod.getAnnotation(Resolve.class);
            if (resolver == null) {
                throw new AssertionError();
            }
            String targetDependency = resolver.depName();
            DependencyDef dependencyDef = (DependencyDef)dependencyDefinitions.get((Object)targetDependency);
            if (dependencyDef == null) {
                throw new IllegalStateException("Could not find dependency with name %s".formatted(targetDependency));
            }
            Object[] targetInputs = resolver.depInputs();
            ImmutableSet sources = (ImmutableSet)Arrays.stream(resolverMethod.getParameters()).map(Parameter::getAnnotations).map(annotations -> Arrays.stream(annotations).filter(annotation -> annotation instanceof Using).map(annotation -> (Using)annotation).findAny()).filter(Optional::isPresent).map(Optional::orElseThrow).toList().stream().map(Using::value).collect(ImmutableSet.toImmutableSet());
            inputResolvers.add(new DefaultInputResolverDefinition((ImmutableSet<String>)sources, new QualifiedInputs(targetDependency, dependencyDef.dataAccessSpec(), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])targetInputs))));
        }
        return inputResolvers;
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag> parseOutputLogicTags(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        Optional<Method> outputLogicMethod = Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(Output.class) != null).findFirst();
        List tagWithArray = outputLogicMethod.map(method -> Arrays.stream(method.getAnnotations()).map(AnnotationTag::from).toList()).orElse(List.of());
        Map collect = tagWithArray.stream().collect(Collectors.toMap(Tag::tagKey, Function.identity()));
        outputLogicMethod.ifPresent(method -> {
            ServiceApi serviceApi;
            Service service = method.getAnnotation(Service.class);
            if (service != null) {
                AnnotationTag<Service> serviceTag = AnnotationTag.from(service);
                collect.put(serviceTag.tagKey(), serviceTag);
            }
            if ((serviceApi = method.getAnnotation(ServiceApi.class)) != null) {
                AnnotationTag<ServiceApi> serviceApiTag = AnnotationTag.from(serviceApi);
                collect.put(serviceApiTag.tagKey(), serviceApiTag);
            }
            collect.put("vajram_type", AnnotationTag.newNamedTag("vajram_type", vajram instanceof IOVajram ? "io_vajram" : "compute_vajram"));
        });
        collect.put("vajram_id", AnnotationTag.newNamedTag("vajram_id", vajram.getId().vajramId()));
        return ImmutableMap.copyOf(collect);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getVajramSourceClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajramClass) {
        Class<?> superclass = vajramClass.getSuperclass();
        if (Object.class.equals(superclass) || superclass == null) {
            throw new IllegalArgumentException();
        }
        if (IOVajram.class.equals(superclass) || ComputeVajram.class.equals(superclass)) {
            return vajramClass;
        }
        return VajramDefinition.getVajramSourceClass(superclass);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getVajram() {
        return this.vajram;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized InputResolverDefinition> getInputResolverDefinitions() {
        return this.inputResolverDefinitions;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag> getOutputLogicTags() {
        return this.outputLogicTags;
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag>> getFacetTags() {
        return this.facetTags;
    }
}

