/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly.cacheproviders.couchbase;

import com.couchbase.client.CouchbaseClient;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lego.gracekelly.api.CacheProvider;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.exceptions.CacheProviderException;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouchBaseCacheProvider<T>
implements CacheProvider<T> {
    private final CouchbaseClient couchbaseClient;
    private final long timeout;

    public CouchBaseCacheProvider(CouchbaseClient couchbaseClient, long timeout) {
        this.couchbaseClient = couchbaseClient;
        this.timeout = timeout;
    }

    public CouchBaseCacheProvider(CouchbaseClient couchbaseClient) {
        this.couchbaseClient = couchbaseClient;
        this.timeout = 0L;
    }

    public CacheEntry<T> get(String key) throws CacheProviderException {
        GetFuture cacheEntryGetFuture = this.couchbaseClient.asyncGet(key);
        try {
            CacheEntry cacheEntry = this.timeout > 0L ? (CacheEntry)cacheEntryGetFuture.get(this.timeout, TimeUnit.SECONDS) : (CacheEntry)cacheEntryGetFuture.get();
            return cacheEntry;
        }
        catch (InterruptedException e) {
            throw new CacheProviderException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheProviderException((Throwable)e);
        }
        catch (TimeoutException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }

    public Boolean put(String key, CacheEntry<T> value) throws CacheProviderException {
        OperationFuture operationFuture = this.couchbaseClient.set(key, value);
        try {
            return (Boolean)operationFuture.get();
        }
        catch (InterruptedException e) {
            throw new CacheProviderException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }
}

