/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly.cacheproviders.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import lego.gracekelly.api.CacheProvider;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.exceptions.CacheProviderException;
import net.spy.memcached.MemcachedClient;

public class MemcachedProvider<T>
implements CacheProvider<T> {
    private final MemcachedClient memcachedClient;
    private static final int INFINITE_TTL = 0;
    private final int TTL;

    public MemcachedProvider(InetSocketAddress inetSocketAddress, int TTL) throws CacheProviderException {
        try {
            this.memcachedClient = new MemcachedClient(new InetSocketAddress[]{inetSocketAddress});
            this.TTL = TTL;
        }
        catch (IOException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }

    public MemcachedProvider(List<InetSocketAddress> inetSocketAddresses, int TTL) throws CacheProviderException {
        try {
            this.memcachedClient = new MemcachedClient(inetSocketAddresses);
            this.TTL = TTL;
        }
        catch (IOException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }

    public CacheEntry<T> get(String key) throws CacheProviderException {
        return (CacheEntry)this.memcachedClient.get(key);
    }

    public Boolean put(String key, CacheEntry<T> value) throws CacheProviderException {
        try {
            return (Boolean)this.memcachedClient.set(key, this.TTL, value).get();
        }
        catch (InterruptedException e) {
            throw new CacheProviderException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }
}

