/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly.examples;

import lego.gracekelly.Kelly;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.examples.GibberishCacheLoader;
import lego.gracekelly.examples.GibberishService;
import lego.gracekelly.examples.LocalCacheProvider;
import lego.gracekelly.exceptions.KellyException;

public class CachedGibberish {
    private final Kelly<String> gibberishCache = new Kelly<String>(new LocalCacheProvider(), new GibberishCacheLoader(), 1);

    public String getGibberish(String prefix) {
        String gibberishValue = null;
        try {
            gibberishValue = this.gibberishCache.get(prefix);
        }
        catch (KellyException e) {
            // empty catch block
        }
        if (gibberishValue == null) {
            gibberishValue = GibberishService.getGibberish(prefix);
            try {
                this.gibberishCache.put(prefix, new CacheEntry<String>(prefix, gibberishValue, 300L));
            }
            catch (KellyException e) {
                e.printStackTrace();
            }
        }
        return gibberishValue;
    }
}

