/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lois;

import com.flipkart.lois.channel.api.ReceiveChannel;
import com.flipkart.lois.channel.api.SendChannel;
import com.flipkart.lois.relay.MulticastRelay;
import com.flipkart.lois.relay.Relay;
import com.flipkart.lois.routine.Routine;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lois {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    public static void go(Routine ... routines) {
        Lois.go(Arrays.asList(routines));
    }

    public static void go(List<Routine> routines) {
        for (Routine routine : routines) {
            executorService.execute(routine);
        }
    }

    public static <T> void mux(SendChannel<T> sinkChannel, ReceiveChannel<T> ... sourceChannels) {
        Lois.mux(sinkChannel, Arrays.asList(sourceChannels));
    }

    public static <T> void mux(SendChannel<T> sinkChannel, List<ReceiveChannel<T>> sourceChannels) {
        for (ReceiveChannel<T> sourceChannel : sourceChannels) {
            Lois.go(new Relay<T>(sinkChannel, sourceChannel));
        }
    }

    public static <T> void deMux(ReceiveChannel<T> sourceChannel, SendChannel<T> ... sinkChannels) {
        Lois.deMux(sourceChannel, Arrays.asList(sinkChannels));
    }

    public static <T> void deMux(ReceiveChannel<T> sourceChannel, List<SendChannel<T>> sinkChannels) {
        for (SendChannel<T> sinkChannel : sinkChannels) {
            Lois.go(new Relay<T>(sinkChannel, sourceChannel));
        }
    }

    public static <T> void multiCast(ReceiveChannel<T> sourceChannel, SendChannel<T> ... sinkChannels) {
        Lois.multiCast(sourceChannel, Arrays.asList(sinkChannels));
    }

    public static <T> void multiCast(ReceiveChannel<T> sourceChannel, List<SendChannel<T>> sinkChannels) {
        Lois.go(new MulticastRelay<T>(sinkChannels, sourceChannel));
    }
}

