/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl;

import com.google.code.or.binlog.BinlogEventParser;
import com.google.code.or.binlog.impl.AbstractBinlogParser;
import com.google.code.or.binlog.impl.event.BinlogEventV4HeaderImpl;
import com.google.code.or.common.util.CodecUtils;
import com.google.code.or.common.util.IOUtils;
import com.google.code.or.common.util.MySQLConstants;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.impl.XInputStreamImpl;
import com.google.code.or.io.util.RamdomAccessFileInputStream;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedBinlogParser
extends AbstractBinlogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedBinlogParser.class);
    protected XInputStream is;
    protected String binlogFileName;
    protected String binlogFilePath;
    protected long stopPosition = 0L;
    protected long startPosition = 4L;

    public FileBasedBinlogParser(String binlogFilePath, String binlogFileName, Long startPosition) {
        this.startPosition = startPosition;
        this.context = new AbstractBinlogParser.Context(binlogFileName, startPosition);
    }

    protected void doStart() throws Exception {
        this.is = this.open(this.binlogFilePath + "/" + this.binlogFileName);
    }

    protected void doStop(long timeout, TimeUnit unit) throws Exception {
        IOUtils.closeQuietly(this.is);
    }

    public String getBinlogFileName() {
        return this.context.getBinlogFileName();
    }

    public String getBinlogFilePath() {
        return this.binlogFilePath;
    }

    public long getStopPosition() {
        return this.stopPosition;
    }

    public void setStopPosition(long stopPosition) {
        this.stopPosition = stopPosition;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    protected void doParse() throws Exception {
        while (this.isRunning() && this.is.available() > 0) {
            try {
                BinlogEventV4HeaderImpl header = new BinlogEventV4HeaderImpl();
                header.setTimestamp(this.is.readLong(4) * 1000L);
                header.setEventType(this.is.readInt(1));
                header.setServerId(this.is.readLong(4));
                header.setEventLength(this.is.readInt(4));
                header.setNextPosition(this.is.readLong(4));
                header.setFlags(this.is.readInt(2));
                header.setTimestampOfReceipt(System.currentTimeMillis());
                this.is.setReadLimit((int)(header.getEventLength() - (long)header.getHeaderLength()));
                if (this.isVerbose() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("read an event, header: {}", (Object)header);
                }
                if (this.stopPosition <= 0L || header.getPosition() <= this.stopPosition) {
                    if (this.eventFilter != null && !this.eventFilter.accepts(header, this.context)) {
                        this.defaultParser.parse(this.is, header, this.context);
                    } else {
                        BinlogEventParser parser = this.getEventParser(header.getEventType());
                        if (parser == null) {
                            parser = this.defaultParser;
                        }
                        parser.parse(this.is, header, this.context);
                    }
                    if (this.is.available() == 0) continue;
                    throw new NestableRuntimeException("assertion failed, available: " + this.is.available() + ", event type: " + header.getEventType());
                }
                break;
            }
            catch (Exception e) {
                IOUtils.closeQuietly(this.is);
                throw e;
            }
            finally {
                this.is.setReadLimit(0);
            }
        }
    }

    protected XInputStream open(String path) throws Exception {
        XInputStreamImpl is = new XInputStreamImpl(new RamdomAccessFileInputStream(new File(path)));
        try {
            byte[] magic = is.readBytes(MySQLConstants.BINLOG_MAGIC.length);
            if (!CodecUtils.equals(magic, MySQLConstants.BINLOG_MAGIC)) {
                throw new NestableRuntimeException("invalid binlog magic, file: " + path);
            }
            if (this.startPosition > (long)MySQLConstants.BINLOG_MAGIC.length) {
                is.skip(this.startPosition - (long)MySQLConstants.BINLOG_MAGIC.length);
            }
            return is;
        }
        catch (Exception e) {
            IOUtils.closeQuietly(is);
            throw e;
        }
    }
}

