/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl;

import com.google.code.or.binlog.BinlogEventParser;
import com.google.code.or.binlog.impl.AbstractBinlogParser;
import com.google.code.or.binlog.impl.event.BinlogEventV4HeaderImpl;
import com.google.code.or.net.Transport;
import com.google.code.or.net.TransportInputStream;
import com.google.code.or.net.impl.packet.AbstractPacket;
import com.google.code.or.net.impl.packet.EOFPacket;
import com.google.code.or.net.impl.packet.ErrorPacket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationBasedBinlogParser
extends AbstractBinlogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationBasedBinlogParser.class);
    protected Transport transport;

    public ReplicationBasedBinlogParser(String binlogFileName, Long currentPosition) {
        this.context = new AbstractBinlogParser.Context(binlogFileName, currentPosition);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop(long timeout, TimeUnit unit) throws Exception {
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getBinlogFileName() {
        return this.context.getBinlogFileName();
    }

    public Long getCurrentPosition() {
        return this.context.getCurrentPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doParse() throws Exception {
        TransportInputStream is = this.transport.getInputStream();
        while (this.isRunning()) {
            try {
                int packetLength = is.readInt(3);
                int packetSequence = is.readInt(1);
                int packetMarker = is.readInt(1);
                if (packetMarker != 0) {
                    AbstractPacket packet;
                    if ((byte)packetMarker == -1) {
                        packet = ErrorPacket.valueOf(packetLength, packetSequence, packetMarker, is);
                        throw new NestableRuntimeException(((ErrorPacket)packet).toString());
                    }
                    if ((byte)packetMarker == -2) {
                        packet = EOFPacket.valueOf(packetLength, packetSequence, packetMarker, is);
                        throw new NestableRuntimeException(((EOFPacket)packet).toString());
                    }
                    throw new NestableRuntimeException("assertion failed, invalid packet marker: " + packetMarker);
                }
                BinlogEventV4HeaderImpl header = new BinlogEventV4HeaderImpl();
                header.setTimestamp(is.readLong(4) * 1000L);
                header.setEventType(is.readInt(1));
                header.setServerId(is.readLong(4));
                header.setEventLength(is.readInt(4));
                header.setNextPosition(is.readLong(4));
                header.setFlags(is.readInt(2));
                header.setTimestampOfReceipt(System.currentTimeMillis());
                if (this.isVerbose() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("received an event, sequence: {}, header: {}", (Object)packetSequence, (Object)header);
                }
                is.setReadLimit((int)header.getDataLength() - this.getChecksumLength());
                if (this.eventFilter != null && !this.eventFilter.accepts(header, this.context)) {
                    this.defaultParser.parse(is, header, this.context);
                } else {
                    BinlogEventParser parser = this.getEventParser(header.getEventType());
                    if (parser == null) {
                        parser = this.defaultParser;
                    }
                    parser.parse(is, header, this.context);
                }
                if (is.available() == 0) continue;
                throw new NestableRuntimeException("assertion failed, available: " + is.available() + ", event type: " + header.getEventType());
            }
            finally {
                is.setReadLimit(0);
                is.skip(this.getChecksumLength());
            }
        }
    }
}

