/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.parser;

import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.binlog.BinlogParserContext;
import com.google.code.or.binlog.impl.event.DeleteRowsEvent;
import com.google.code.or.binlog.impl.event.TableMapEvent;
import com.google.code.or.binlog.impl.parser.AbstractRowEventParser;
import com.google.code.or.common.glossary.Row;
import com.google.code.or.io.XInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteRowsEventParser
extends AbstractRowEventParser {
    public DeleteRowsEventParser() {
        super(25);
    }

    @Override
    public void parse(XInputStream is, BinlogEventV4Header header, BinlogParserContext context) throws IOException {
        long tableId = is.readLong(6);
        TableMapEvent tme = context.getTableMapEvent(tableId);
        if (this.rowEventFilter != null && !this.rowEventFilter.accepts(header, context, tme)) {
            is.skip(is.available());
            return;
        }
        DeleteRowsEvent event = new DeleteRowsEvent(header);
        event.setTableId(tableId);
        event.setReserved(is.readInt(2));
        event.setColumnCount(is.readUnsignedLong());
        event.setUsedColumns(is.readBit(event.getColumnCount().intValue(), true));
        event.setRows(this.parseRows(is, tme, event));
        context.getEventListener().onEvents(event);
    }

    protected List<Row> parseRows(XInputStream is, TableMapEvent tme, DeleteRowsEvent dre) throws IOException {
        LinkedList<Row> r = new LinkedList<Row>();
        while (is.available() > 0) {
            r.add(this.parseRow(is, tme, dre.getUsedColumns()));
        }
        return r;
    }
}

