/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.parser;

import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.binlog.BinlogParserContext;
import com.google.code.or.binlog.StatusVariable;
import com.google.code.or.binlog.impl.event.QueryEvent;
import com.google.code.or.binlog.impl.parser.AbstractBinlogEventParser;
import com.google.code.or.binlog.impl.variable.status.QAutoIncrement;
import com.google.code.or.binlog.impl.variable.status.QCatalogCode;
import com.google.code.or.binlog.impl.variable.status.QCatalogNzCode;
import com.google.code.or.binlog.impl.variable.status.QCharsetCode;
import com.google.code.or.binlog.impl.variable.status.QCharsetDatabaseCode;
import com.google.code.or.binlog.impl.variable.status.QFlags2Code;
import com.google.code.or.binlog.impl.variable.status.QInvoker;
import com.google.code.or.binlog.impl.variable.status.QLcTimeNamesCode;
import com.google.code.or.binlog.impl.variable.status.QMasterDataWrittenCode;
import com.google.code.or.binlog.impl.variable.status.QMicroseconds;
import com.google.code.or.binlog.impl.variable.status.QSQLModeCode;
import com.google.code.or.binlog.impl.variable.status.QTableMapForUpdateCode;
import com.google.code.or.binlog.impl.variable.status.QTimeZoneCode;
import com.google.code.or.binlog.impl.variable.status.QUpdatedDBNames;
import com.google.code.or.io.XInputStream;
import com.google.code.or.io.util.XDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEventParser
extends AbstractBinlogEventParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryEventParser.class);

    public QueryEventParser() {
        super(2);
    }

    @Override
    public void parse(XInputStream is, BinlogEventV4Header header, BinlogParserContext context) throws IOException {
        QueryEvent event = new QueryEvent(header);
        event.setThreadId(is.readLong(4));
        event.setElapsedTime(is.readLong(4));
        event.setDatabaseNameLength(is.readInt(1));
        event.setErrorCode(is.readInt(2));
        event.setStatusVariablesLength(is.readInt(2));
        event.setStatusVariables(this.parseStatusVariables(is.readBytes(event.getStatusVariablesLength())));
        event.setDatabaseName(is.readNullTerminatedString());
        event.setSql(is.readFixedLengthString(is.available()));
        context.getEventListener().onEvents(event);
    }

    protected List<StatusVariable> parseStatusVariables(byte[] data) throws IOException {
        ArrayList<StatusVariable> r = new ArrayList<StatusVariable>();
        XDeserializer d = new XDeserializer(data);
        boolean abort = false;
        block16: while (!abort && d.available() > 0) {
            int type = d.readInt(1);
            switch (type) {
                case 3: {
                    r.add(QAutoIncrement.valueOf(d));
                    continue block16;
                }
                case 2: {
                    r.add(QCatalogCode.valueOf(d));
                    continue block16;
                }
                case 6: {
                    r.add(QCatalogNzCode.valueOf(d));
                    continue block16;
                }
                case 4: {
                    r.add(QCharsetCode.valueOf(d));
                    continue block16;
                }
                case 8: {
                    r.add(QCharsetDatabaseCode.valueOf(d));
                    continue block16;
                }
                case 0: {
                    r.add(QFlags2Code.valueOf(d));
                    continue block16;
                }
                case 7: {
                    r.add(QLcTimeNamesCode.valueOf(d));
                    continue block16;
                }
                case 1: {
                    r.add(QSQLModeCode.valueOf(d));
                    continue block16;
                }
                case 9: {
                    r.add(QTableMapForUpdateCode.valueOf(d));
                    continue block16;
                }
                case 5: {
                    r.add(QTimeZoneCode.valueOf(d));
                    continue block16;
                }
                case 10: {
                    r.add(QMasterDataWrittenCode.valueOf(d));
                    continue block16;
                }
                case 11: {
                    r.add(QInvoker.valueOf(d));
                    continue block16;
                }
                case 12: {
                    r.add(QUpdatedDBNames.valueOf(d));
                    continue block16;
                }
                case 13: {
                    r.add(QMicroseconds.valueOf(d));
                    continue block16;
                }
            }
            LOGGER.warn("unknown status variable type: " + type);
            abort = true;
        }
        return r;
    }
}

