/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary;

import com.google.code.or.common.util.CodecUtils;
import com.google.code.or.io.util.XDeserializer;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class Metadata
implements Serializable {
    private static final long serialVersionUID = 4634414541769527837L;
    private final byte[] type;
    private final int[] metadata;

    public Metadata(byte[] type, int[] metadata) {
        this.type = type;
        this.metadata = metadata;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("metadata", this.metadata).toString();
    }

    public byte getType(int column) {
        return this.type[column];
    }

    public int getMetadata(int column) {
        return this.metadata[column];
    }

    public static final Metadata valueOf(byte[] type, byte[] data) throws IOException {
        int[] metadata = new int[type.length];
        XDeserializer d = new XDeserializer(data);
        block5: for (int i = 0; i < type.length; ++i) {
            int t = CodecUtils.toUnsigned(type[i]);
            switch (t) {
                case 4: 
                case 5: 
                case 17: 
                case 18: 
                case 19: 
                case 249: 
                case 250: 
                case 251: 
                case 252: {
                    metadata[i] = d.readInt(1);
                    continue block5;
                }
                case 15: 
                case 16: 
                case 246: {
                    metadata[i] = d.readInt(2);
                    continue block5;
                }
                case 247: 
                case 248: 
                case 254: {
                    metadata[i] = CodecUtils.toInt(d.readBytes(2), 0, 2);
                    continue block5;
                }
                default: {
                    metadata[i] = 0;
                }
            }
        }
        return new Metadata(type, metadata);
    }
}

