/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pair<T> {
    private T before;
    private T after;

    public Pair() {
    }

    public Pair(T before, T after) {
        this.before = before;
        this.after = after;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("before", this.before).append("after", this.after).toString();
    }

    public T getBefore() {
        return this.before;
    }

    public void setBefore(T before) {
        this.before = before;
    }

    public T getAfter() {
        return this.after;
    }

    public void setAfter(T after) {
        this.after = after;
    }

    public void swap() {
        T t = this.before;
        this.before = this.after;
        this.after = t;
    }

    public static void swap(Pair<?> p) {
        Pair.doSwap(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void doSwap(Pair<T> p) {
        Pair<T> pair = p;
        synchronized (pair) {
            T t = p.before;
            p.before = p.after;
            p.after = t;
        }
    }
}

