/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class TinyColumn
implements Column {
    private static final long serialVersionUID = 3629858638897033423L;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 256;
    private static final TinyColumn[] CACHE;
    private final int value;

    private TinyColumn(int value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public static final TinyColumn valueOf(int value) {
        if (value < 0 || value > 256) {
            throw new IllegalArgumentException("invalid value: " + value);
        }
        return CACHE[value];
    }

    static {
        int i;
        CACHE = new TinyColumn[256];
        for (i = 0; i < 128; ++i) {
            TinyColumn.CACHE[i] = new TinyColumn(i);
        }
        for (i = 128; i < 256; ++i) {
            TinyColumn.CACHE[i] = new TinyColumn(i - 256);
        }
    }
}

