/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackoffTimer.class);
    public static final long NO_MORE_RETRIES = -1L;
    private BackoffTimerConfig config;
    private String name;
    private long startTime;
    private long retryCount;
    private long currentSleep;

    public BackoffTimer(BackoffTimerConfig config, String name) {
        this.config = config;
        this.name = name;
        this.reset();
    }

    public void reset() {
        this.currentSleep = this.config.getInitSleep();
        this.retryCount = 0L;
        this.startTime = -1L;
    }

    public long backoff() {
        if (0L == this.retryCount) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.retryCount;
        this.currentSleep = this.config.calculateNextSleep(this.currentSleep);
        if (this.config.getMaxRetryNum() >= 0L && this.retryCount > this.config.getMaxRetryNum()) {
            return -1L;
        }
        return this.currentSleep;
    }

    public boolean sleep() {
        if (0L >= this.currentSleep) {
            return true;
        }
        try {
            Thread.sleep(this.currentSleep);
            return true;
        }
        catch (InterruptedException ex) {
            LOGGER.info(this.name + ": sleep interrupted");
            return false;
        }
    }

    public long getRemainingRetriesCount() {
        return this.config.getMaxRetryNum() >= 0L ? this.config.getMaxRetryNum() - this.retryCount : Long.MAX_VALUE;
    }

    public long getTotalRetryTime() {
        return this.startTime > 0L ? System.currentTimeMillis() - this.startTime : 0L;
    }

    public BackoffTimerConfig getConfig() {
        return this.config;
    }

    public void setConfig(BackoffTimerConfig config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(long retryCount) {
        this.retryCount = retryCount;
    }

    public long getCurrentSleep() {
        return this.currentSleep;
    }

    public void setCurrentSleep(long currentSleep) {
        this.currentSleep = currentSleep;
    }

    public static class BackoffTimerConfig {
        public static final BackoffTimerConfig LINEAR_BACKOFF_UNLIMITED_RETRIES = new BackoffTimerConfig(1L, 60000L, 1.0, 5L, -1L);
        public static final BackoffTimerConfig EXPONENTIAL_BACKOFF_UNLIMITED_RETRIES = new BackoffTimerConfig(1L, 60000L, 2.0, 5L, -1L);
        private final long initSleep;
        private final long maxSleep;
        private final double sleepIncrementFactor;
        private final long sleepIncrementDelta;
        private final long maxRetryNum;

        public BackoffTimerConfig(long initSleep, long maxSleep, double sleepIncrementFactor, long sleepInrementDelta, long maxRetryNum) {
            this.initSleep = initSleep;
            this.maxSleep = maxSleep;
            this.sleepIncrementFactor = sleepIncrementFactor;
            this.sleepIncrementDelta = sleepInrementDelta;
            this.maxRetryNum = maxRetryNum;
        }

        public long calculateNextSleep(long curSleep) {
            if (curSleep < 0L) {
                return this.initSleep;
            }
            long newSleep = (long)(this.sleepIncrementFactor * (double)curSleep) + this.sleepIncrementDelta;
            if (newSleep <= curSleep) {
                newSleep = curSleep + 1L;
            }
            return Math.min(this.maxSleep, newSleep);
        }

        public long getInitSleep() {
            return this.initSleep;
        }

        public long getMaxSleep() {
            return this.maxSleep;
        }

        public double getSleepIncrementFactor() {
            return this.sleepIncrementFactor;
        }

        public long getSleepIncrementDelta() {
            return this.sleepIncrementDelta;
        }

        public long getMaxRetryNum() {
            return this.maxRetryNum;
        }

        public String toString() {
            return "BackoffTimerStaticConfig [initSleep=" + this.initSleep + ", maxSleep=" + this.maxSleep + ", sleepIncrementFactor=" + this.sleepIncrementFactor + ", sleepIncrementDelta=" + this.sleepIncrementDelta + ", maxRetryNum=" + this.maxRetryNum + "]";
        }
    }
}

